/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.mock.core;

import org.javaswift.joss.command.impl.core.httpstatus.HttpStatusChecker;
import org.javaswift.joss.exception.CommandException;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.StoredObject;
import org.javaswift.joss.swift.Swift;
import org.javaswift.joss.swift.SwiftResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandMock<T> {
    public static final Logger LOG = LoggerFactory.getLogger(CommandMock.class);
    protected Account account;
    protected Container container;
    protected StoredObject object;
    protected boolean allowErrorLog = true;
    protected Swift swift;

    public CommandMock(Swift swift, Account account) {
        this(swift, account, null, null);
    }

    public CommandMock(Swift swift, Account account, Container container) {
        this(swift, account, container, null);
    }

    public CommandMock(Swift swift, Account account, Container container, StoredObject object) {
        this.swift = swift;
        this.account = account;
        this.container = container;
        this.object = object;
    }

    public void setAllowErrorLog(boolean allowErrorLog) {
        this.allowErrorLog = allowErrorLog;
    }

    protected void applyDelay() {
        if (this.swift.getMillisDelay() > 0L) {
            try {
                Thread.sleep(this.swift.getMillisDelay());
            }
            catch (InterruptedException e) {
                throw new CommandException("Sleep interrupted", e);
            }
        }
    }

    public T call() {
        this.applyDelay();
        try {
            int suggestedStatus = this.swift.getStatus(this.getClass());
            SwiftResult<T> result = suggestedStatus == -1 ? this.callSwift() : new SwiftResult(suggestedStatus);
            HttpStatusChecker.verifyCode(this.getStatusCheckers(), result.getStatus());
            return result.getPayload();
        }
        catch (CommandException err) {
            if (this.allowErrorLog) {
                LOG.error("JOSS / " + this.getClass().getSimpleName() + ", HTTP status " + err.getHttpStatusCode());
            }
            throw err;
        }
    }

    public abstract SwiftResult<T> callSwift();

    public abstract HttpStatusChecker[] getStatusCheckers();
}

