/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.factory;

import org.apache.http.client.HttpClient;
import org.javaswift.joss.client.factory.AuthenticationMethod;
import org.javaswift.joss.command.impl.identity.BasicAuthenticationCommandImpl;
import org.javaswift.joss.command.impl.identity.ExternalAuthenticationCommandImpl;
import org.javaswift.joss.command.impl.identity.KeystoneAuthenticationCommandImpl;
import org.javaswift.joss.command.impl.identity.TempAuthAuthenticationCommandImpl;
import org.javaswift.joss.command.shared.factory.AuthenticationCommandFactory;
import org.javaswift.joss.command.shared.identity.AuthenticationCommand;

public class AuthenticationCommandFactoryImpl
implements AuthenticationCommandFactory {
    @Override
    public AuthenticationCommand createAuthenticationCommand(HttpClient httpClient, AuthenticationMethod authenticationMethod, String url, String tenantName, String tenantId, String username, String password, AuthenticationMethod.AccessProvider accessProvier) {
        if (authenticationMethod == AuthenticationMethod.BASIC) {
            return new BasicAuthenticationCommandImpl(httpClient, url, username, password, tenantName);
        }
        if (authenticationMethod == AuthenticationMethod.TEMPAUTH) {
            return new TempAuthAuthenticationCommandImpl(httpClient, url, username, password, tenantName);
        }
        if (authenticationMethod == AuthenticationMethod.EXTERNAL) {
            return new ExternalAuthenticationCommandImpl(httpClient, url, accessProvier);
        }
        return new KeystoneAuthenticationCommandImpl(httpClient, url, tenantName, tenantId, username, password);
    }
}

