/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.javers.repository.mongo.MongoDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MongoSchemaManager {
    static final int ASC = 1;
    static final String SNAPSHOTS = "jv_snapshots";
    static final String COMMIT_ID = "commitMetadata.id";
    static final String COMMIT_DATE = "commitMetadata.commitDate";
    static final String COMMIT_DATE_INSTANT = "commitMetadata.commitDateInstant";
    static final String COMMIT_AUTHOR = "commitMetadata.author";
    static final String COMMIT_PROPERTIES = "commitMetadata.properties";
    static final String COMMIT_PROPERTIES_INDEX_NAME = "commitMetadata.properties_key_value";
    static final String GLOBAL_ID_KEY = "globalId_key";
    static final String GLOBAL_ID_ENTITY = "globalId.entity";
    static final String GLOBAL_ID_OWNER_ID_ENTITY = "globalId.ownerId.entity";
    static final String GLOBAL_ID_FRAGMENT = "globalId.fragment";
    static final String GLOBAL_ID_VALUE_OBJECT = "globalId.valueObject";
    static final String SNAPSHOT_VERSION = "version";
    static final String CHANGED_PROPERTIES = "changedProperties";
    static final String OBJECT_ID = "_id";
    static final String SNAPSHOT_TYPE = "type";
    private static final Logger logger = LoggerFactory.getLogger(MongoSchemaManager.class);
    private final MongoDatabase mongo;

    MongoSchemaManager(MongoDatabase mongo) {
        this.mongo = mongo;
    }

    public void ensureSchema(MongoDialect dialect) {
        Object stringCommitId;
        MongoCollection<Document> snapshots = this.snapshotsCollection();
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_KEY, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_VALUE_OBJECT, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_ENTITY, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_OWNER_ID_ENTITY, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(CHANGED_PROPERTIES, (Object)1));
        if (dialect == MongoDialect.MONGO_DB) {
            snapshots.createIndex((Bson)new BasicDBObject("commitMetadata.properties.key", (Object)1).append("commitMetadata.properties.value", (Object)1), new IndexOptions().name(COMMIT_PROPERTIES_INDEX_NAME));
        } else if (dialect == MongoDialect.DOCUMENT_DB) {
            snapshots.createIndex((Bson)new BasicDBObject("commitMetadata.properties.key", (Object)1));
            snapshots.createIndex((Bson)new BasicDBObject("commitMetadata.properties.value", (Object)1));
        }
        this.headCollection();
        Document doc = (Document)snapshots.find().first();
        if (doc != null && (stringCommitId = ((Map)doc.get((Object)"commitMetadata")).get("id")) instanceof String) {
            logger.info("executing db migration script, from JaVers 1.1 to 1.2 ...");
            Document update = new Document("eval", (Object)"function() { \n    db.jv_snapshots.find().forEach( \n      function(snapshot) { \n        snapshot.commitMetadata.id = Number(snapshot.commitMetadata.id); \n        db.jv_snapshots.save(snapshot); } \n    );     return 'ok'; \n}");
            Document ret = this.mongo.runCommand((Bson)update);
            logger.info("result: \n " + ret.toJson());
        }
    }

    MongoCollection<Document> snapshotsCollection() {
        return this.mongo.getCollection(SNAPSHOTS);
    }

    MongoCollection<Document> headCollection() {
        return this.mongo.getCollection("jv_head_id");
    }
}

