/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.function.Function;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;

class LatestSnapshotCache {
    private final Cache<GlobalId, Optional<CdoSnapshot>> cache;
    private final Function<GlobalId, Optional<CdoSnapshot>> source;
    private final boolean disabled;

    LatestSnapshotCache(int size, Function<GlobalId, Optional<CdoSnapshot>> source) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)size).build();
        this.source = source;
        this.disabled = size == 0;
    }

    Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        if (this.disabled) {
            return this.source.apply(globalId);
        }
        Optional fromCache = (Optional)this.cache.getIfPresent((Object)globalId);
        if (fromCache != null) {
            return fromCache;
        }
        Optional<CdoSnapshot> fromDb = this.source.apply(globalId);
        this.cache.put((Object)globalId, fromDb);
        return fromDb;
    }

    void put(CdoSnapshot cdoSnapshot) {
        if (this.disabled) {
            return;
        }
        this.cache.put((Object)cdoSnapshot.getGlobalId(), Optional.of(cdoSnapshot));
    }
}

