/*
 * Decompiled with CFR 0.152.
 */
package org.javers.hibernate.integration;

import java.util.Optional;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.pojo.javassist.JavassistLazyInitializer;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.ObjectAccessProxy;

public class HibernateUnproxyObjectAccessHook<T>
implements ObjectAccessHook<T> {
    public Optional<ObjectAccessProxy<T>> createAccessor(T entity) {
        if (entity instanceof HibernateProxy) {
            LazyInitializer lazyInitializer = ((HibernateProxy)entity).getHibernateLazyInitializer();
            return this.fromLazyInitializer(lazyInitializer);
        }
        if (entity instanceof JavassistLazyInitializer) {
            JavassistLazyInitializer proxy = (JavassistLazyInitializer)entity;
            return this.fromLazyInitializer((LazyInitializer)proxy);
        }
        return Optional.empty();
    }

    private Optional<ObjectAccessProxy<T>> fromLazyInitializer(LazyInitializer lazyInitializer) {
        return Optional.of(new ObjectAccessProxy(() -> lazyInitializer.getImplementation(), lazyInitializer.getPersistentClass(), (Object)lazyInitializer.getIdentifier()));
    }
}

