/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func2;

public final class GenericCollector {
    private static final Set<Collector.Characteristics> ORDERED = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.CONCURRENT));
    private static final Set<Collector.Characteristics> UNORDERED = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT));

    private GenericCollector() {
    }

    @Nonnull
    public static <T, C> Collector<T, ?, C> ordered(@Nonnull C initialValue, @Nonnull C empty, @Nonnull Predicate<C> isEmpty, @Nonnull Func2<C, T, C> adder, @Nonnull Func2<C, C, C> combiner) {
        return new CollectorImpl(ORDERED, initialValue, empty, isEmpty, adder, combiner);
    }

    @Nonnull
    public static <T, C> Collector<T, ?, C> unordered(@Nonnull C initialValue, @Nonnull C empty, @Nonnull Predicate<C> isEmpty, @Nonnull Func2<C, T, C> adder, @Nonnull Func2<C, C, C> combiner) {
        return new CollectorImpl(UNORDERED, initialValue, empty, isEmpty, adder, combiner);
    }

    private static class Accumulator<T, C> {
        private Func2<C, T, C> adder;
        private Func2<C, C, C> combiner;
        private C list;

        private Accumulator(@Nonnull Func2<C, T, C> adder, @Nonnull Func2<C, C, C> combiner, @Nonnull C list) {
            this.adder = adder;
            this.combiner = combiner;
            this.list = list;
        }

        private synchronized void add(T value) {
            this.list = this.adder.apply(this.list, value);
        }

        private synchronized Accumulator<T, C> combine(Accumulator<T, C> other) {
            this.list = this.combiner.apply(this.list, other.list);
            return this;
        }
    }

    @Immutable
    private static class CollectorImpl<T, C>
    implements Collector<T, Accumulator<T, C>, C> {
        private final Set<Collector.Characteristics> characteristics;
        private final C initialValues;
        private final C empty;
        private final Func2<C, T, C> adder;
        private final Func2<C, C, C> combiner;

        private CollectorImpl(@Nonnull Set<Collector.Characteristics> characteristics, @Nonnull C initialValues, @Nonnull C empty, @Nonnull Predicate<C> isEmpty, @Nonnull Func2<C, T, C> adder, @Nonnull Func2<C, C, C> combiner) {
            this.characteristics = characteristics;
            this.initialValues = isEmpty.test(initialValues) ? null : initialValues;
            this.empty = empty;
            this.adder = adder;
            this.combiner = combiner;
        }

        @Override
        public Supplier<Accumulator<T, C>> supplier() {
            return () -> new Accumulator(this.adder, this.combiner, this.empty);
        }

        @Override
        public BiConsumer<Accumulator<T, C>, T> accumulator() {
            return (a, v) -> ((Accumulator)a).add(v);
        }

        @Override
        public BinaryOperator<Accumulator<T, C>> combiner() {
            return (left, right) -> ((Accumulator)left).combine((Accumulator)right);
        }

        @Override
        public Function<Accumulator<T, C>, C> finisher() {
            if (this.initialValues == null) {
                return a -> ((Accumulator)a).list;
            }
            return a -> this.combiner.apply(this.initialValues, ((Accumulator)a).list);
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

