/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1Throws;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.Proc1Throws;

@Immutable
public interface Holder<T> {
    public boolean isEmpty();

    public boolean isNonEmpty();

    public boolean isFilled();

    public T getValue();

    public T getValueOrNull();

    public T getValueOr(T var1);

    default public void ifPresent(@Nonnull Consumer<? super T> consumer) {
        if (this.isFilled()) {
            consumer.accept(this.getValue());
        }
    }

    default public <E extends Exception> void ifPresentThrows(@Nonnull Proc1Throws<? super T, E> consumer) throws E {
        if (this.isFilled()) {
            consumer.apply(this.getValue());
        }
    }

    default public <U> Holder<U> map(@Nonnull Function<? super T, ? extends U> transforminator) {
        return this.isFilled() ? Holders.of(transforminator.apply(this.getValue())) : Holders.of();
    }

    default public <U, E extends Exception> Holder<U> mapThrows(@Nonnull Func1Throws<? super T, ? extends U, E> transforminator) throws E {
        return this.isFilled() ? Holders.of(transforminator.apply(this.getValue())) : Holders.of();
    }

    default public T orElse(T defaultValue) {
        return this.getValueOr(defaultValue);
    }

    default public T orElseGet(@Nonnull Supplier<? extends T> supplier) {
        return this.isFilled() ? this.getValue() : supplier.get();
    }

    default public <X extends Throwable> T orElseThrow(@Nonnull Supplier<? extends X> supplier) throws X {
        if (this.isFilled()) {
            return this.getValue();
        }
        throw (Throwable)supplier.get();
    }
}

