/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.util.function.Function;

public interface Indexed<T> {
    public T get(int var1);

    public int size();

    default public T[] subArray(int offset, int limit) {
        Object[] answer = new Object[limit - offset];
        for (int i = offset; i < limit; ++i) {
            answer[i - offset] = this.get(i);
        }
        return answer;
    }

    public static <S, T> Indexed<T> transformed(final Indexed<S> source, final Function<S, T> transforminator) {
        return new Indexed<T>(){

            @Override
            public T get(int index) {
                return transforminator.apply(source.get(index));
            }

            @Override
            public int size() {
                return source.size();
            }
        };
    }
}

