/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.IndexedProc1;
import org.javimmutable.collections.IndexedProc1Throws;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;

@Immutable
public interface JImmutableArray<T>
extends Indexed<T>,
Insertable<JImmutableMap.Entry<Integer, T>, JImmutableArray<T>>,
IterableStreamable<JImmutableMap.Entry<Integer, T>>,
InvariantCheckable,
Serializable {
    @Override
    @Nullable
    public T get(int var1);

    public T getValueOr(int var1, @Nullable T var2);

    @Nonnull
    public Holder<T> find(int var1);

    @Nonnull
    public Holder<JImmutableMap.Entry<Integer, T>> findEntry(int var1);

    @Nonnull
    public JImmutableArray<T> assign(int var1, @Nullable T var2);

    @Nonnull
    public JImmutableArray<T> delete(int var1);

    @Override
    public int size();

    public boolean isEmpty();

    public boolean isNonEmpty();

    @Nonnull
    public JImmutableArray<T> deleteAll();

    @Nonnull
    public Map<Integer, T> getMap();

    @Nonnull
    public IterableStreamable<Integer> keys();

    @Nonnull
    public IterableStreamable<T> values();

    @Override
    public void forEach(@Nonnull IndexedProc1<T> var1);

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull IndexedProc1Throws<T, E> var1) throws E;

    @Nonnull
    public Builder<T> arrayBuilder();

    public static interface Builder<T> {
        @Nonnull
        public JImmutableArray<T> build();

        public int size();

        @Nonnull
        public Builder<T> put(int var1, T var2);

        @Nonnull
        public Builder<T> add(T var1);

        public Builder<T> setNextIndex(int var1);

        @Nonnull
        default public Builder<T> add(Iterator<? extends T> source) {
            while (source.hasNext()) {
                this.add(source.next());
            }
            return this;
        }

        @Nonnull
        default public Builder<T> add(Iterable<? extends T> source) {
            return this.add(source.iterator());
        }

        @Nonnull
        default public <K extends T> Builder<T> add(K ... source) {
            return this.add((Iterable<? extends T>)Arrays.asList(source));
        }

        @Nonnull
        default public Builder<T> add(Indexed<? extends T> source, int offset, int limit) {
            for (int i = offset; i < limit; ++i) {
                this.add(source.get(i));
            }
            return this;
        }

        @Nonnull
        default public Builder<T> add(Indexed<? extends T> source) {
            return this.add(source, 0, source.size());
        }

        @Nonnull
        default public Builder<T> putAll(@Nonnull Iterator<JImmutableMap.Entry<Integer, ? extends T>> source) {
            while (source.hasNext()) {
                JImmutableMap.Entry<Integer, T> entry = source.next();
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Nonnull
        public Builder<T> clear();
    }
}

