/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;

@Immutable
public interface JImmutableList<T>
extends Insertable<T, JImmutableList<T>>,
Indexed<T>,
IterableStreamable<T>,
InvariantCheckable,
Serializable {
    @Override
    public int size();

    @Override
    public T get(int var1);

    @Nonnull
    public JImmutableList<T> assign(int var1, @Nullable T var2);

    @Override
    @Nonnull
    public JImmutableList<T> insert(@Nullable T var1);

    @Nonnull
    public JImmutableList<T> insert(int var1, @Nullable T var2);

    @Nonnull
    public JImmutableList<T> insertFirst(@Nullable T var1);

    @Nonnull
    public JImmutableList<T> insertLast(@Nullable T var1);

    @Override
    @Nonnull
    public JImmutableList<T> insertAll(@Nonnull Iterable<? extends T> var1);

    @Override
    @Nonnull
    public JImmutableList<T> insertAll(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAll(int var1, @Nonnull Iterable<? extends T> var2);

    @Nonnull
    public JImmutableList<T> insertAll(int var1, @Nonnull Iterator<? extends T> var2);

    @Nonnull
    public JImmutableList<T> insertAllFirst(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllFirst(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllLast(@Nonnull Iterable<? extends T> var1);

    @Nonnull
    public JImmutableList<T> insertAllLast(@Nonnull Iterator<? extends T> var1);

    @Nonnull
    public JImmutableList<T> deleteFirst();

    @Nonnull
    public JImmutableList<T> deleteLast();

    public boolean isEmpty();

    public boolean isNonEmpty();

    @Nonnull
    public JImmutableList<T> delete(int var1);

    @Nonnull
    public JImmutableList<T> deleteAll();

    @Nonnull
    public List<T> getList();

    @Nonnull
    public JImmutableList<T> reverse();

    @Nonnull
    public JImmutableList<T> select(@Nonnull Predicate<T> var1);

    @Nonnull
    public JImmutableList<T> reject(@Nonnull Predicate<T> var1);

    @Nonnull
    default public Collector<T, ?, JImmutableList<T>> listCollector() {
        return GenericCollector.ordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> a.insertAll((Iterable)b));
    }

    public <A> JImmutableList<A> transform(@Nonnull Func1<T, A> var1);

    public <A> JImmutableList<A> transformSome(@Nonnull Func1<T, Holder<A>> var1);

    @Nonnull
    public JImmutableList<T> prefix(int var1);

    @Nonnull
    public JImmutableList<T> suffix(int var1);

    @Nonnull
    public JImmutableList<T> middle(int var1, int var2);

    @Nonnull
    public JImmutableList<T> slice(int var1, int var2);

    public static interface Builder<T> {
        @Nonnull
        public JImmutableList<T> build();

        public int size();

        @Nonnull
        public Builder<T> add(T var1);

        @Nonnull
        default public Builder<T> add(Iterator<? extends T> source) {
            while (source.hasNext()) {
                this.add(source.next());
            }
            return this;
        }

        @Nonnull
        default public Builder<T> add(Iterable<? extends T> source) {
            return this.add(source.iterator());
        }

        @Nonnull
        default public <K extends T> Builder<T> add(K ... source) {
            return this.add((Iterable<? extends T>)Arrays.asList(source));
        }

        @Nonnull
        default public Builder<T> add(Indexed<? extends T> source, int offset, int limit) {
            for (int i = offset; i < limit; ++i) {
                this.add(source.get(i));
            }
            return this;
        }

        @Nonnull
        default public Builder<T> add(Indexed<? extends T> source) {
            return this.add(source, 0, source.size());
        }

        @Nonnull
        public Builder<T> clear();
    }
}

