/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.Mapped;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;

@Immutable
public interface JImmutableListMap<K, V>
extends Insertable<JImmutableMap.Entry<K, V>, JImmutableListMap<K, V>>,
Mapped<K, JImmutableList<V>>,
IterableStreamable<JImmutableMap.Entry<K, JImmutableList<V>>>,
InvariantCheckable,
Serializable {
    @Nonnull
    public JImmutableList<V> getList(@Nonnull K var1);

    @Nonnull
    public JImmutableListMap<K, V> assign(@Nonnull K var1, @Nonnull JImmutableList<V> var2);

    @Override
    @Nonnull
    public JImmutableListMap<K, V> insert(@Nonnull JImmutableMap.Entry<K, V> var1);

    @Nonnull
    public JImmutableListMap<K, V> insert(@Nonnull K var1, @Nullable V var2);

    @Nonnull
    default public JImmutableListMap<K, V> insertAll(@Nonnull K key, @Nonnull Iterable<? extends V> values) {
        return this.assign(key, (JImmutableList<V>)this.getList(key).insertAll(values));
    }

    @Nonnull
    default public JImmutableListMap<K, V> insertAll(@Nonnull K key, @Nonnull Iterator<? extends V> values) {
        return this.assign(key, (JImmutableList<V>)this.getList(key).insertAll(values));
    }

    @Nonnull
    public JImmutableListMap<K, V> delete(@Nonnull K var1);

    @Nonnull
    default public JImmutableListMap<K, V> deleteAll(@Nonnull Iterable<? extends K> keys) {
        return this.deleteAll(keys.iterator());
    }

    @Nonnull
    default public JImmutableListMap<K, V> deleteAll(@Nonnull Iterator<? extends K> keys) {
        JImmutableListMap<K, V> map = this;
        while (keys.hasNext()) {
            map = map.delete(keys.next());
        }
        return map;
    }

    @Override
    default public JImmutableListMap<K, V> transform(@Nonnull K key, @Nonnull Func1<JImmutableList<V>, JImmutableList<V>> transform) {
        JImmutableList<V> current = this.getList(key);
        JImmutableList<V> transformed = transform.apply(current);
        return transformed == current ? this : this.assign(key, transformed);
    }

    default public JImmutableListMap<K, V> transformIfPresent(@Nonnull K key, @Nonnull Func1<JImmutableList<V>, JImmutableList<V>> transform) {
        JImmutableList<V> transformed;
        JImmutableList current = (JImmutableList)this.get(key);
        if (current != null && (transformed = transform.apply(current)) != current) {
            return this.assign(key, transformed);
        }
        return this;
    }

    public int size();

    public boolean isEmpty();

    default public boolean isNonEmpty() {
        return !this.isEmpty();
    }

    @Nonnull
    public JImmutableListMap<K, V> deleteAll();

    @Nonnull
    public IterableStreamable<K> keys();

    @Nonnull
    public IterableStreamable<V> values(@Nonnull K var1);

    @Nonnull
    public IterableStreamable<JImmutableMap.Entry<K, V>> entries();

    default public void forEach(@Nonnull Proc2<K, JImmutableList<V>> proc) {
        for (JImmutableMap.Entry e : this) {
            proc.apply(e.getKey(), (JImmutableList<V>)e.getValue());
        }
    }

    default public <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, JImmutableList<V>, E> proc) throws E {
        for (JImmutableMap.Entry e : this) {
            proc.apply(e.getKey(), (JImmutableList<V>)e.getValue());
        }
    }

    @Nonnull
    default public Collector<JImmutableMap.Entry<K, V>, ?, JImmutableListMap<K, V>> listMapCollector() {
        return GenericCollector.ordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert((JImmutableMap.Entry)v), (a, b) -> (JImmutableListMap)a.insertAll(b.entries()));
    }
}

