/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.Mapped;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;

@Immutable
public interface JImmutableMap<K, V>
extends Insertable<Entry<? extends K, ? extends V>, JImmutableMap<K, V>>,
Mapped<K, V>,
IterableStreamable<Entry<K, V>>,
InvariantCheckable,
Serializable {
    @Override
    @Nonnull
    public JImmutableMap<K, V> insert(@Nonnull Entry<? extends K, ? extends V> var1);

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K var1);

    @Nonnull
    public Holder<Entry<K, V>> findEntry(@Nonnull K var1);

    @Nonnull
    public JImmutableMap<K, V> assign(@Nonnull K var1, V var2);

    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull JImmutableMap<? extends K, ? extends V> var1);

    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull Map<? extends K, ? extends V> var1);

    @Nonnull
    public JImmutableMap<K, V> delete(@Nonnull K var1);

    public int size();

    public boolean isEmpty();

    public boolean isNonEmpty();

    @Nonnull
    public JImmutableMap<K, V> deleteAll();

    @Nonnull
    public Map<K, V> getMap();

    @Nonnull
    public IterableStreamable<K> keys();

    @Nonnull
    public IterableStreamable<V> values();

    @Nonnull
    public Builder<K, V> mapBuilder();

    @Nonnull
    default public Collector<Entry<K, V>, ?, JImmutableMap<K, V>> mapCollector() {
        return GenericCollector.unordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert((Entry)v), (a, b) -> (JImmutableMap)a.insertAll(b));
    }

    @Nonnull
    default public JImmutableMap<K, V> update(@Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        Holder<V> current = this.find(key);
        V newValue = generator.apply(current);
        return this.assign(key, newValue);
    }

    default public void forEach(@Nonnull Proc2<K, V> proc) {
        for (Entry e : this) {
            proc.apply(e.getKey(), e.getValue());
        }
    }

    default public <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, V, E> proc) throws E {
        for (Entry e : this) {
            proc.apply(e.getKey(), e.getValue());
        }
    }

    @Override
    default public <R> R reduce(R sum, @Nonnull Sum2<K, V, R> proc) {
        for (Entry e : this) {
            sum = proc.apply(sum, e.getKey(), e.getValue());
        }
        return sum;
    }

    default public <R, E extends Exception> R reduceThrows(R sum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        for (Entry e : this) {
            sum = proc.apply(sum, e.getKey(), e.getValue());
        }
        return sum;
    }

    @Nonnull
    public JImmutableMap<K, V> select(@Nonnull BiPredicate<K, V> var1);

    @Nonnull
    public JImmutableMap<K, V> reject(@Nonnull BiPredicate<K, V> var1);

    public static interface Builder<K, V> {
        @Nonnull
        public JImmutableMap<K, V> build();

        @Nonnull
        public Builder<K, V> add(@Nonnull K var1, V var2);

        public int size();

        @Nonnull
        default public Builder<K, V> add(Entry<? extends K, ? extends V> e) {
            return this.add(e.getKey(), e.getValue());
        }

        @Nonnull
        default public Builder<K, V> add(Iterator<? extends Entry<? extends K, ? extends V>> source) {
            while (source.hasNext()) {
                this.add(source.next());
            }
            return this;
        }

        @Nonnull
        default public Builder<K, V> add(Map<? extends K, ? extends V> source) {
            for (Map.Entry<K, V> e : source.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
            return this;
        }

        @Nonnull
        default public Builder<K, V> add(Iterable<? extends Entry<? extends K, ? extends V>> source) {
            return this.add(source.iterator());
        }

        @Nonnull
        default public <T extends Entry<? extends K, ? extends V>> Builder<K, V> add(T ... source) {
            return this.add((Iterable<? extends Entry<? extends K, ? extends V>>)Arrays.asList(source));
        }

        @Nonnull
        default public Builder<K, V> add(Indexed<? extends Entry<? extends K, ? extends V>> source, int offset, int limit) {
            for (int i = offset; i < limit; ++i) {
                this.add(source.get(i));
            }
            return this;
        }

        @Nonnull
        default public Builder<K, V> add(Indexed<? extends Entry<? extends K, ? extends V>> source) {
            return this.add(source, 0, source.size());
        }

        @Nonnull
        default public Builder<K, V> add(@Nonnull Builder<K, V> other) {
            this.add((Iterable<? extends Entry<? extends K, ? extends V>>)other.build());
            return this;
        }

        @Nonnull
        public Builder<K, V> clear();
    }

    @Immutable
    public static interface Entry<K, V> {
        @Nonnull
        public K getKey();

        public V getValue();
    }
}

