/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Insertable;
import org.javimmutable.collections.InvariantCheckable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.Mapped;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;

@Immutable
public interface JImmutableSetMap<K, V>
extends Insertable<JImmutableMap.Entry<K, V>, JImmutableSetMap<K, V>>,
Mapped<K, JImmutableSet<V>>,
IterableStreamable<JImmutableMap.Entry<K, JImmutableSet<V>>>,
InvariantCheckable,
Serializable {
    @Nonnull
    public JImmutableSet<V> getSet(@Nonnull K var1);

    @Nonnull
    public JImmutableSetMap<K, V> assign(@Nonnull K var1, @Nonnull JImmutableSet<V> var2);

    @Override
    @Nonnull
    public JImmutableSetMap<K, V> insert(@Nonnull JImmutableMap.Entry<K, V> var1);

    @Nonnull
    public JImmutableSetMap<K, V> insert(@Nonnull K var1, @Nonnull V var2);

    @Nonnull
    public JImmutableSetMap<K, V> insertAll(@Nonnull K var1, @Nonnull Iterable<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> insertAll(@Nonnull K var1, @Nonnull Iterator<? extends V> var2);

    public boolean contains(@Nonnull K var1);

    public boolean contains(@Nonnull K var1, @Nullable V var2);

    public boolean containsAll(@Nonnull K var1, @Nonnull Iterable<? extends V> var2);

    public boolean containsAll(@Nonnull K var1, @Nonnull Iterator<? extends V> var2);

    public boolean containsAny(@Nonnull K var1, @Nonnull Iterable<? extends V> var2);

    public boolean containsAny(@Nonnull K var1, @Nonnull Iterator<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> delete(@Nonnull K var1);

    @Nonnull
    public JImmutableSetMap<K, V> delete(@Nonnull K var1, @Nonnull V var2);

    @Nonnull
    public JImmutableSetMap<K, V> deleteAll(@Nonnull K var1, @Nonnull Iterable<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> deleteAll(@Nonnull K var1, @Nonnull Iterator<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> union(@Nonnull K var1, @Nonnull Iterable<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> union(@Nonnull K var1, @Nonnull Iterator<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K var1, @Nonnull Iterable<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K var1, @Nonnull Iterator<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K var1, @Nonnull JImmutableSet<? extends V> var2);

    @Nonnull
    public JImmutableSetMap<K, V> intersection(@Nonnull K var1, @Nonnull Set<? extends V> var2);

    @Override
    default public JImmutableSetMap<K, V> transform(@Nonnull K key, @Nonnull Func1<JImmutableSet<V>, JImmutableSet<V>> transform) {
        JImmutableSet<V> current = this.getSet(key);
        JImmutableSet<V> transformed = transform.apply(current);
        return transformed == current ? this : this.assign(key, transformed);
    }

    default public JImmutableSetMap<K, V> transformIfPresent(@Nonnull K key, @Nonnull Func1<JImmutableSet<V>, JImmutableSet<V>> transform) {
        JImmutableSet<V> transformed;
        JImmutableSet current = (JImmutableSet)this.get(key);
        if (current != null && (transformed = transform.apply(current)) != current) {
            return this.assign(key, transformed);
        }
        return this;
    }

    public int size();

    public boolean isEmpty();

    default public boolean isNonEmpty() {
        return !this.isEmpty();
    }

    @Nonnull
    public JImmutableSetMap<K, V> deleteAll();

    @Nonnull
    public IterableStreamable<K> keys();

    @Nonnull
    public IterableStreamable<V> values(@Nonnull K var1);

    @Nonnull
    public IterableStreamable<JImmutableMap.Entry<K, V>> entries();

    default public void forEach(@Nonnull Proc2<K, JImmutableSet<V>> proc) {
        for (JImmutableMap.Entry e : this) {
            proc.apply(e.getKey(), (JImmutableSet<V>)e.getValue());
        }
    }

    default public <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, JImmutableSet<V>, E> proc) throws E {
        for (JImmutableMap.Entry e : this) {
            proc.apply(e.getKey(), (JImmutableSet<V>)e.getValue());
        }
    }

    @Nonnull
    default public Collector<JImmutableMap.Entry<K, V>, ?, JImmutableSetMap<K, V>> setMapCollector() {
        return GenericCollector.unordered(this, this.deleteAll(), a -> a.isEmpty(), (a, v) -> a.insert((JImmutableMap.Entry)v), (a, b) -> (JImmutableSetMap)a.insertAll(b.entries()));
    }
}

