/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections;

import javax.annotation.Nonnull;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.IndexedProc1;
import org.javimmutable.collections.IndexedProc1Throws;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.Temp;

public interface SplitableIterable<T>
extends Iterable<T> {
    @Override
    @Nonnull
    public SplitableIterator<T> iterator();

    default public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
        for (Object value : this) {
            proc.apply(value);
        }
    }

    default public <V> V reduce(V initialValue, Func2<V, T, V> accumulator) {
        Temp.Var1<V> sum = Temp.var(initialValue);
        this.forEach(x -> {
            sum.x = accumulator.apply(sum.x, x);
        });
        return (V)sum.x;
    }

    default public <V, E extends Exception> V reduceThrows(V initialValue, Sum1Throws<T, V, E> accumulator) throws E {
        Temp.Var1<V> sum = Temp.var(initialValue);
        this.forEachThrows(x -> {
            sum.x = accumulator.apply(sum.x, x);
        });
        return (V)sum.x;
    }

    default public void indexedForEach(@Nonnull IndexedProc1<T> proc) {
        Temp.Int1 index = Temp.intVar(0);
        this.forEach(v -> proc.apply(index.a++, v));
    }

    default public <E extends Exception> void indexedForEachThrows(@Nonnull IndexedProc1Throws<T, E> proc) throws E {
        Temp.Int1 index = Temp.intVar(0);
        this.forEachThrows(v -> proc.apply(index.a++, v));
    }
}

