/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.IndexedProc1;
import org.javimmutable.collections.IndexedProc1Throws;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableArray;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.TrieArrayBuilder;
import org.javimmutable.collections.array.TrieArrayNode;
import org.javimmutable.collections.common.ArrayToMapAdaptor;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.iterators.TransformIterator;
import org.javimmutable.collections.serialization.JImmutableArrayProxy;

public class JImmutableTrieArray<T>
implements Serializable,
JImmutableArray<T> {
    private static final JImmutableTrieArray EMPTY = new JImmutableTrieArray(TrieArrayNode.empty());
    private static final int SPLITERATOR_CHARACTERISTICS = 1040;
    private final TrieArrayNode<T> root;
    private final int size;

    private JImmutableTrieArray(@Nonnull TrieArrayNode<T> root) {
        this.root = root;
        this.size = root.size();
    }

    @Nonnull
    public static <T> JImmutableArray<T> of() {
        return EMPTY;
    }

    @Nonnull
    public static <T> JImmutableArray.Builder<T> builder() {
        return new Builder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableArray<T>> collector() {
        return Collector.of(() -> new Builder(), (b, v) -> b.add(v), (b1, b2) -> (Builder)b1.add(((Builder)b2).iterator()), b -> b.build(), new Collector.Characteristics[0]);
    }

    @Override
    @Nullable
    public T get(int index) {
        return this.getValueOr(index, null);
    }

    @Override
    public T getValueOr(int index, @Nullable T defaultValue) {
        return this.root.getValueOr(index, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<T> find(int index) {
        return this.root.find(index);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<Integer, T>> findEntry(int index) {
        return this.find(index).map(v -> MapEntry.entry(index, v));
    }

    @Override
    @Nonnull
    public JImmutableArray<T> assign(int index, @Nullable T value) {
        TrieArrayNode<T> newChild = this.root.assign(index, value);
        return new JImmutableTrieArray<T>(newChild);
    }

    @Override
    @Nonnull
    public JImmutableArray<T> delete(int index) {
        TrieArrayNode<T> child = this.root;
        TrieArrayNode<T> newChild = child.delete(index);
        if (newChild == child) {
            return this;
        }
        if (newChild.isEmpty()) {
            return JImmutableTrieArray.of();
        }
        return new JImmutableTrieArray<T>(newChild);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isNonEmpty() {
        return this.size != 0;
    }

    @Override
    @Nonnull
    public JImmutableArray<T> deleteAll() {
        return JImmutableTrieArray.of();
    }

    @Override
    @Nonnull
    public Map<Integer, T> getMap() {
        return ArrayToMapAdaptor.of(this);
    }

    @Override
    @Nonnull
    public JImmutableArray<T> insert(JImmutableMap.Entry<Integer, T> e) {
        return e == null ? this : this.assign(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public JImmutableArray<T> getInsertableSelf() {
        return this;
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants(null);
        int computedSize = this.root.size();
        if (computedSize != this.size) {
            throw new IllegalStateException(String.format("size mismatch: expected=%d actual=%d", computedSize, this.size));
        }
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return this.root.entries().iterator();
    }

    @Override
    @Nonnull
    public IterableStreamable<Integer> keys() {
        return this.root.keys().streamable(1040);
    }

    @Override
    @Nonnull
    public IterableStreamable<T> values() {
        return this.root.values().streamable(1040);
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    public void forEach(Consumer<? super JImmutableMap.Entry<Integer, T>> action) {
        this.forEach((int i, T v) -> action.accept(MapEntry.entry(i, v)));
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<JImmutableMap.Entry<Integer, T>, E> proc) throws E {
        this.forEachThrows((int i, T v) -> proc.apply(MapEntry.entry(i, v)));
    }

    @Override
    public void forEach(@Nonnull IndexedProc1<T> proc) {
        this.root.forEach(proc);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull IndexedProc1Throws<T, E> proc) throws E {
        this.root.forEachThrows(proc);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JImmutableArray && IteratorHelper.iteratorEquals(this.iterator(), ((JImmutableArray)o).iterator());
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    @Override
    @Nonnull
    public JImmutableArray.Builder<T> arrayBuilder() {
        return new Builder();
    }

    private Object writeReplace() {
        return new JImmutableArrayProxy(this);
    }

    @ThreadSafe
    public static class Builder<T>
    implements JImmutableArray.Builder<T> {
        private final TrieArrayBuilder<T> builder = new TrieArrayBuilder();

        private Builder() {
        }

        @Override
        public synchronized int size() {
            return this.builder.size();
        }

        @Override
        @Nonnull
        public synchronized JImmutableArray.Builder<T> clear() {
            this.builder.reset();
            return this;
        }

        @Override
        @Nonnull
        public synchronized JImmutableArray.Builder<T> add(T value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public synchronized JImmutableArray.Builder<T> put(int index, T value) {
            this.builder.put(index, value);
            return this;
        }

        @Override
        public synchronized JImmutableArray.Builder<T> setNextIndex(int index) {
            this.builder.setNextIndex(index);
            return this;
        }

        @Override
        @Nonnull
        public synchronized JImmutableArray<T> build() {
            return this.builder.size() == 0 ? JImmutableTrieArray.of() : new JImmutableTrieArray(this.builder.buildRoot());
        }

        @Nonnull
        private synchronized Iterator<T> iterator() {
            return TransformIterator.of(this.builder.iterator(), JImmutableMap.Entry::getValue);
        }
    }
}

