/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.ArrayAssignMapper;
import org.javimmutable.collections.array.TrieArrayNode;
import org.javimmutable.collections.common.ArrayHelper;
import org.javimmutable.collections.common.BitmaskMath;
import org.javimmutable.collections.common.IntArrayMappedTrieMath;

@NotThreadSafe
public class TrieArrayBuilder<T> {
    private final Node<T> root = new Node(TrieArrayNode.ROOT_SHIFT_COUNT, 0);
    private int nextIndex = 0;

    @Nonnull
    public TrieArrayNode<T> buildRoot() {
        return ((Node)this.root).toNode();
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    public void setNextIndex(int nextIndex) {
        this.nextIndex = nextIndex;
    }

    public void add(T value) {
        this.put(this.nextIndex++, value);
    }

    public void put(int index, T value) {
        ((Node)this.root).put(TrieArrayNode.flip(index), value);
    }

    public <K, V> void assign(@Nonnull ArrayAssignMapper<K, V, T> mapper, @Nonnull K key, V value) {
        ((Node)this.root).mappedPut(mapper, TrieArrayNode.flip(key.hashCode()), key, value);
    }

    public int size() {
        return ((Node)this.root).size();
    }

    public void reset() {
        this.nextIndex = 0;
        ((Node)this.root).reset();
    }

    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<Integer, T>> iterator() {
        return this.buildRoot().entries().iterator();
    }

    @Nonnull
    private static <T> Node<T>[] allocate() {
        return new Node[64];
    }

    private static class Node<T> {
        private final int shiftCount;
        private final int baseIndex;
        private long valuesBitmask;
        private final T[] values;
        private long nodesBitmask;
        private final Node<T>[] nodes;
        private int size;

        private Node(int shiftCount, int index) {
            assert (shiftCount <= TrieArrayNode.ROOT_SHIFT_COUNT);
            assert (shiftCount >= 0);
            this.shiftCount = shiftCount;
            this.baseIndex = IntArrayMappedTrieMath.baseIndexAtShift(shiftCount, index);
            this.valuesBitmask = 0L;
            this.values = ArrayHelper.allocate(64);
            this.nodesBitmask = 0L;
            this.nodes = TrieArrayBuilder.allocate();
        }

        private void reset() {
            Arrays.fill(this.values, null);
            Arrays.fill(this.nodes, null);
            this.valuesBitmask = 0L;
            this.nodesBitmask = 0L;
            this.size = 0;
        }

        private void put(int index, T value) {
            assert (IntArrayMappedTrieMath.baseIndexAtShift(this.shiftCount, index) == this.baseIndex);
            int myIndex = IntArrayMappedTrieMath.indexAtShift(this.shiftCount, index);
            long bit = BitmaskMath.bitFromIndex(myIndex);
            if (this.shiftCount == TrieArrayNode.findShiftForIndex(index)) {
                this.values[myIndex] = value;
                if (BitmaskMath.bitIsAbsent(this.valuesBitmask, bit)) {
                    this.valuesBitmask = BitmaskMath.addBit(this.valuesBitmask, bit);
                    ++this.size;
                }
            } else {
                Node<T> node = this.nodes[myIndex];
                if (node == null) {
                    this.nodesBitmask = BitmaskMath.addBit(this.nodesBitmask, bit);
                    this.nodes[myIndex] = node = new Node<T>(this.shiftCount - 1, index);
                } else {
                    this.size -= node.size;
                }
                super.put(index, value);
                this.size += node.size;
            }
        }

        private <K, V> void mappedPut(@Nonnull ArrayAssignMapper<K, V, T> mapper, int index, @Nonnull K key, V value) {
            assert (IntArrayMappedTrieMath.baseIndexAtShift(this.shiftCount, index) == this.baseIndex);
            int myIndex = IntArrayMappedTrieMath.indexAtShift(this.shiftCount, index);
            long bit = BitmaskMath.bitFromIndex(myIndex);
            if (this.shiftCount == TrieArrayNode.findShiftForIndex(index)) {
                if (BitmaskMath.bitIsPresent(this.valuesBitmask, bit)) {
                    this.size -= mapper.mappedSize(this.values[myIndex]);
                    this.values[myIndex] = mapper.mappedAssign(this.values[myIndex], key, value);
                } else {
                    this.valuesBitmask = BitmaskMath.addBit(this.valuesBitmask, bit);
                    this.values[myIndex] = mapper.mappedAssign(key, value);
                }
                this.size += mapper.mappedSize(this.values[myIndex]);
            } else {
                Node<T> node = this.nodes[myIndex];
                if (node == null) {
                    this.nodesBitmask = BitmaskMath.addBit(this.nodesBitmask, bit);
                    this.nodes[myIndex] = node = new Node<T>(this.shiftCount - 1, index);
                } else {
                    this.size -= node.size;
                }
                super.mappedPut(mapper, index, key, value);
                this.size += node.size;
            }
        }

        @Nonnull
        private TrieArrayNode<T> toNode() {
            T[] answerValues = TrieArrayNode.allocateValues(BitmaskMath.bitCount(this.valuesBitmask));
            BitmaskMath.copyToCompactArrayUsingBitmask(this.valuesBitmask, this.values, answerValues, x -> x);
            TrieArrayNode<T>[] answerNodes = TrieArrayNode.allocateNodes(BitmaskMath.bitCount(this.nodesBitmask));
            BitmaskMath.copyToCompactArrayUsingBitmask(this.nodesBitmask, this.nodes, answerNodes, child -> child.toNode());
            return new TrieArrayNode(this.shiftCount, this.baseIndex, this.valuesBitmask, answerValues, this.nodesBitmask, answerNodes, this.size);
        }

        private int size() {
            return this.size;
        }
    }
}

