/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.array;

import java.util.ArrayList;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.array.TrieArrayNode;
import org.javimmutable.collections.common.ArrayHelper;
import org.javimmutable.collections.common.BitmaskMath;
import org.javimmutable.collections.common.LongArrayMappedTrieMath;
import org.javimmutable.collections.indexed.IndexedList;
import org.javimmutable.collections.iterators.GenericIterator;

public class TrieLongArrayNode<T> {
    static final int ROOT_SHIFT_COUNT = LongArrayMappedTrieMath.MAX_SHIFT_NUMBER;
    private static final long SIGN_BIT = Long.MIN_VALUE;
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final TrieLongArrayNode[] EMPTY_NODES = new TrieLongArrayNode[0];
    private static final TrieLongArrayNode EMPTY = new TrieLongArrayNode<Object>(ROOT_SHIFT_COUNT, 0L, 0L, EMPTY_VALUES, 0L, EMPTY_NODES, 0);
    private final int shiftCount;
    private final long baseIndex;
    private final long valuesBitmask;
    private final T[] values;
    private final long nodesBitmask;
    private final TrieLongArrayNode<T>[] nodes;
    private final int size;

    TrieLongArrayNode(int shiftCount, long baseIndex, long valuesBitmask, T[] values, long nodesBitmask, @Nonnull TrieLongArrayNode<T>[] nodes, int size) {
        assert (BitmaskMath.bitCount(valuesBitmask) == values.length);
        assert (BitmaskMath.bitCount(nodesBitmask) == nodes.length);
        this.shiftCount = shiftCount;
        this.baseIndex = baseIndex;
        this.valuesBitmask = valuesBitmask;
        this.values = values;
        this.nodesBitmask = nodesBitmask;
        this.nodes = nodes;
        this.size = size;
        assert (TrieLongArrayNode.checkChildShifts(shiftCount, nodes));
    }

    @Nonnull
    public static <T> TrieLongArrayNode<T> empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public T getValueOr(long index, T defaultValue) {
        index = TrieLongArrayNode.flip(index);
        int shiftCountForValue = TrieLongArrayNode.findShiftForIndex(index);
        return this.getValueOrImpl(shiftCountForValue, index, defaultValue);
    }

    @Nonnull
    public TrieLongArrayNode<T> assign(long index, T value) {
        index = TrieLongArrayNode.flip(index);
        int shiftCountForValue = TrieLongArrayNode.findShiftForIndex(index);
        return this.assignImpl(ROOT_SHIFT_COUNT, shiftCountForValue, index, value);
    }

    @Nonnull
    public TrieLongArrayNode<T> delete(long index) {
        index = TrieLongArrayNode.flip(index);
        int shiftCountForValue = TrieLongArrayNode.findShiftForIndex(index);
        return this.deleteImpl(shiftCountForValue, index);
    }

    @Nonnull
    public GenericIterator.Iterable<Long> keys() {
        return this.iterable((valueIndex, arrayIndex) -> this.computeUserIndexForValue(valueIndex), nodeIndex -> this.nodes[nodeIndex].keys());
    }

    @Nonnull
    public GenericIterator.Iterable<T> values() {
        return this.iterable((valueIndex, arrayIndex) -> this.values[arrayIndex], nodeIndex -> this.nodes[nodeIndex].values());
    }

    @Nonnull
    public GenericIterator.Iterable<JImmutableMap.Entry<Long, T>> entries() {
        return this.iterable((valueIndex, arrayIndex) -> MapEntry.entry(this.computeUserIndexForValue(valueIndex), this.values[arrayIndex]), nodeIndex -> this.nodes[nodeIndex].entries());
    }

    public void checkInvariants() {
        if (BitmaskMath.bitCount(this.valuesBitmask) != this.values.length) {
            throw new IllegalStateException(String.format("invalid bitmask for values array: bitmask=%s length=%d", Long.toBinaryString(this.valuesBitmask), this.values.length));
        }
        if (BitmaskMath.bitCount(this.nodesBitmask) != this.nodes.length) {
            throw new IllegalStateException(String.format("invalid bitmask for nodes array: bitmask=%s length=%d", Long.toBinaryString(this.nodesBitmask), this.nodes.length));
        }
        if (!TrieLongArrayNode.checkChildShifts(this.shiftCount, this.nodes)) {
            throw new IllegalStateException("one or more nodes invalid for this branch");
        }
        int computedSize = TrieLongArrayNode.computeSize(this.nodes) + this.values.length;
        if (computedSize != this.size) {
            throw new IllegalStateException(String.format("size mismatch: size=%d computed=%d", this.size, computedSize));
        }
    }

    private T getValueOrImpl(int shiftCountForValue, long index, T defaultValue) {
        int shiftCount = this.shiftCount;
        if (shiftCountForValue > shiftCount) {
            return defaultValue;
        }
        if (LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index) != this.baseIndex) {
            return defaultValue;
        }
        int myIndex = LongArrayMappedTrieMath.indexAtShift(shiftCount, index);
        long bit = BitmaskMath.bitFromIndex(myIndex);
        if (shiftCountForValue == shiftCount) {
            long bitmask = this.valuesBitmask;
            if (BitmaskMath.bitIsPresent(bitmask, bit)) {
                int arrayIndex = BitmaskMath.arrayIndexForBit(bitmask, bit);
                return this.values[arrayIndex];
            }
        } else {
            long bitmask = this.nodesBitmask;
            if (BitmaskMath.bitIsPresent(bitmask, bit)) {
                int arrayIndex = BitmaskMath.arrayIndexForBit(bitmask, bit);
                return super.getValueOrImpl(shiftCountForValue, index, defaultValue);
            }
        }
        return defaultValue;
    }

    @Nonnull
    private TrieLongArrayNode<T> assignImpl(int shiftCount, int shiftCountForValue, long index, T value) {
        int thisShiftCount = this.shiftCount;
        long baseIndex = this.baseIndex;
        assert (LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index) == LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, baseIndex));
        assert (shiftCount >= thisShiftCount);
        assert (shiftCount >= shiftCountForValue);
        if (shiftCount != thisShiftCount) {
            int ancestorShiftCount = TrieLongArrayNode.findCommonAncestorShift(baseIndex + LongArrayMappedTrieMath.shift(thisShiftCount, 1L), index);
            assert (ancestorShiftCount <= shiftCount);
            if (ancestorShiftCount > thisShiftCount) {
                TrieLongArrayNode<T> ancestor = TrieLongArrayNode.forNode(ancestorShiftCount, baseIndex, this);
                return super.assignImpl(ancestorShiftCount, shiftCountForValue, index, value);
            }
            shiftCount = thisShiftCount;
        }
        assert (LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index) == baseIndex);
        int myIndex = LongArrayMappedTrieMath.indexAtShift(shiftCount, index);
        long bit = BitmaskMath.bitFromIndex(myIndex);
        long valuesBitmask = this.valuesBitmask;
        long nodesBitmask = this.nodesBitmask;
        if (shiftCount == shiftCountForValue) {
            T[] values = this.values;
            long newBitmask = BitmaskMath.addBit(valuesBitmask, bit);
            int arrayIndex = BitmaskMath.arrayIndexForBit(valuesBitmask, bit);
            if (BitmaskMath.bitIsPresent(valuesBitmask, bit)) {
                T[] newValues = ArrayHelper.assign(values, arrayIndex, value);
                return new TrieLongArrayNode<T>(shiftCount, baseIndex, newBitmask, newValues, nodesBitmask, this.nodes, this.size);
            }
            T[] newValues = ArrayHelper.insert(TrieArrayNode::allocateValues, values, arrayIndex, value);
            return new TrieLongArrayNode(shiftCount, baseIndex, newBitmask, newValues, nodesBitmask, this.nodes, this.size + 1);
        }
        int arrayIndex = BitmaskMath.arrayIndexForBit(nodesBitmask, bit);
        if (BitmaskMath.bitIsPresent(nodesBitmask, bit)) {
            TrieLongArrayNode<T> node = this.nodes[arrayIndex];
            TrieLongArrayNode<T> newNode = super.assignImpl(shiftCount - 1, shiftCountForValue, index, value);
            TrieLongArrayNode<T>[] newNodes = ArrayHelper.assign(this.nodes, arrayIndex, newNode);
            int newSize = this.size - node.size() + newNode.size();
            return new TrieLongArrayNode<T>(shiftCount, baseIndex, valuesBitmask, this.values, nodesBitmask, newNodes, newSize);
        }
        long newBitmask = BitmaskMath.addBit(nodesBitmask, bit);
        TrieLongArrayNode<T> newNode = TrieLongArrayNode.forValue(shiftCountForValue, index, value);
        if (valuesBitmask == 0L && nodesBitmask == 0L) {
            return newNode;
        }
        TrieLongArrayNode<T>[] newNodes = ArrayHelper.insert(TrieLongArrayNode::allocateNodes, this.nodes, arrayIndex, newNode);
        return new TrieLongArrayNode<T>(shiftCount, baseIndex, valuesBitmask, this.values, newBitmask, newNodes, this.size + 1);
    }

    @Nonnull
    private TrieLongArrayNode<T> deleteImpl(int shiftCountForValue, long index) {
        int arrayIndex;
        TrieLongArrayNode<T> node;
        TrieLongArrayNode<T> newNode;
        int shiftCount = this.shiftCount;
        if (shiftCountForValue > shiftCount) {
            return this;
        }
        if (LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index) != this.baseIndex) {
            return this;
        }
        int myIndex = LongArrayMappedTrieMath.indexAtShift(shiftCount, index);
        long bit = BitmaskMath.bitFromIndex(myIndex);
        long valuesBitmask = this.valuesBitmask;
        long nodesBitmask = this.nodesBitmask;
        T[] values = this.values;
        TrieLongArrayNode<T>[] nodes = this.nodes;
        if (shiftCountForValue == shiftCount) {
            if (BitmaskMath.bitIsPresent(valuesBitmask, bit)) {
                if (this.size == 1) {
                    return TrieLongArrayNode.empty();
                }
                long newBitmask = BitmaskMath.removeBit(valuesBitmask, bit);
                int arrayIndex2 = BitmaskMath.arrayIndexForBit(valuesBitmask, bit);
                T[] newValues = ArrayHelper.delete(TrieArrayNode::allocateValues, values, arrayIndex2);
                return new TrieLongArrayNode(shiftCount, this.baseIndex, newBitmask, newValues, nodesBitmask, nodes, this.size - 1);
            }
        } else if (BitmaskMath.bitIsPresent(nodesBitmask, bit) && (newNode = super.deleteImpl(shiftCountForValue, index)) != node) {
            int newSize = this.size - node.size() + newNode.size();
            if (newSize == 0) {
                return TrieLongArrayNode.empty();
            }
            if (newNode.isEmpty()) {
                long newBitmask = BitmaskMath.removeBit(nodesBitmask, bit);
                if (valuesBitmask == 0L && BitmaskMath.bitCount(newBitmask) == 1) {
                    return nodes[BitmaskMath.arrayIndexForBit(nodesBitmask, newBitmask)];
                }
                TrieLongArrayNode<T>[] newNodes = ArrayHelper.delete(TrieLongArrayNode::allocateNodes, nodes, arrayIndex);
                return new TrieLongArrayNode<T>(shiftCount, this.baseIndex, valuesBitmask, values, newBitmask, newNodes, newSize);
            }
            TrieLongArrayNode<T>[] newNodes = ArrayHelper.assign(nodes, arrayIndex, newNode);
            return new TrieLongArrayNode<T>(shiftCount, this.baseIndex, valuesBitmask, values, nodesBitmask, newNodes, newSize);
        }
        return this;
    }

    private <V> IterableStreamable<V> streamable(@Nonnull LongIntFunc<V> valueFunction, @Nonnull IntFunction<GenericIterator.Iterable<V>> nodeFunction) {
        return this.iterable(valueFunction, nodeFunction).streamable(1040);
    }

    private <V> GenericIterator.Iterable<V> iterable(final @Nonnull LongIntFunc<V> valueFunction, final @Nonnull IntFunction<GenericIterator.Iterable<V>> nodeFunction) {
        return new GenericIterator.Iterable<V>(){

            @Override
            @Nullable
            public GenericIterator.State<V> iterateOverRange(@Nullable GenericIterator.State<V> parent, int offset, int limit) {
                ArrayList iterables = new ArrayList(TrieLongArrayNode.this.values.length + TrieLongArrayNode.this.nodes.length);
                long combinedBitmask = BitmaskMath.addBit(TrieLongArrayNode.this.valuesBitmask, TrieLongArrayNode.this.nodesBitmask);
                while (combinedBitmask != 0L) {
                    long bit = BitmaskMath.leastBit(combinedBitmask);
                    if (BitmaskMath.bitIsPresent(TrieLongArrayNode.this.valuesBitmask, bit)) {
                        int valueIndex = BitmaskMath.indexForBit(bit);
                        int arrayIndex = BitmaskMath.arrayIndexForBit(TrieLongArrayNode.this.valuesBitmask, bit);
                        iterables.add(GenericIterator.singleValueIterable(valueFunction.apply(valueIndex, arrayIndex)));
                    }
                    if (BitmaskMath.bitIsPresent(TrieLongArrayNode.this.nodesBitmask, bit)) {
                        int nodeIndex = BitmaskMath.arrayIndexForBit(TrieLongArrayNode.this.nodesBitmask, bit);
                        iterables.add(nodeFunction.apply(nodeIndex));
                    }
                    combinedBitmask = BitmaskMath.removeBit(combinedBitmask, bit);
                }
                assert (iterables.size() == TrieLongArrayNode.this.values.length + TrieLongArrayNode.this.nodes.length);
                return GenericIterator.multiIterableState(parent, IndexedList.retained(iterables), offset, limit);
            }

            @Override
            public int iterableSize() {
                return TrieLongArrayNode.this.size;
            }
        };
    }

    @Nonnull
    private static <T> TrieLongArrayNode<T> forValue(int shiftCount, long index, T value) {
        assert (shiftCount == TrieLongArrayNode.findShiftForIndex(index));
        long baseIndex = LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index);
        long valueBitmask = BitmaskMath.bitFromIndex(LongArrayMappedTrieMath.indexAtShift(shiftCount, index));
        T[] values = ArrayHelper.newArray(value);
        long nodeBitmask = 0L;
        TrieLongArrayNode<T>[] nodes = TrieLongArrayNode.emptyNodes();
        return new TrieLongArrayNode<T>(shiftCount, baseIndex, valueBitmask, values, 0L, nodes, 1);
    }

    @Nonnull
    private static <T> TrieLongArrayNode<T> forNode(int shiftCount, long nodeBaseIndex, @Nonnull TrieLongArrayNode<T> node) {
        long baseIndex = LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, nodeBaseIndex);
        long valueBitmask = 0L;
        T[] values = TrieLongArrayNode.emptyValues();
        long nodeBitmask = BitmaskMath.bitFromIndex(LongArrayMappedTrieMath.indexAtShift(shiftCount, nodeBaseIndex));
        TrieLongArrayNode<T>[] nodes = TrieLongArrayNode.allocateNodes(1);
        nodes[0] = node;
        return new TrieLongArrayNode<T>(shiftCount, baseIndex, 0L, values, nodeBitmask, nodes, node.size());
    }

    private long computeUserIndexForValue(Long valueIndex) {
        return TrieLongArrayNode.flip(this.baseIndex + LongArrayMappedTrieMath.shift(this.shiftCount, valueIndex));
    }

    @Nonnull
    static <T> T[] allocateValues(int size) {
        return size == 0 ? TrieLongArrayNode.emptyValues() : new Object[size];
    }

    @Nonnull
    static <T> TrieLongArrayNode<T>[] allocateNodes(int size) {
        return size == 0 ? TrieLongArrayNode.emptyNodes() : new TrieLongArrayNode[size];
    }

    @Nonnull
    private static <T> T[] emptyValues() {
        return EMPTY_VALUES;
    }

    @Nonnull
    private static <T> TrieLongArrayNode<T>[] emptyNodes() {
        return EMPTY_NODES;
    }

    static int findShiftForIndex(long index) {
        return LongArrayMappedTrieMath.findMinimumShiftForZeroBelowHashCode(index);
    }

    static int findCommonAncestorShift(long index1, long index2) {
        int shift1 = TrieLongArrayNode.findShiftForIndex(index1);
        int shift2 = TrieLongArrayNode.findShiftForIndex(index2);
        int shiftCount = Math.max(shift1, shift2);
        while (LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index1) != LongArrayMappedTrieMath.baseIndexAtShift(shiftCount, index2)) {
            ++shiftCount;
        }
        assert (shiftCount <= ROOT_SHIFT_COUNT);
        return shiftCount;
    }

    static long flip(long index) {
        return index ^ Long.MIN_VALUE;
    }

    private static <T> boolean checkChildShifts(int shiftCount, @Nonnull TrieLongArrayNode<T>[] nodes) {
        for (TrieLongArrayNode<T> node : nodes) {
            if (shiftCount > node.shiftCount && !node.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static <T> int computeSize(@Nonnull TrieLongArrayNode<T>[] children) {
        int total = 0;
        for (TrieLongArrayNode<T> child : children) {
            total += child.size();
        }
        return total;
    }

    private static interface LongIntFunc<R> {
        public R apply(long var1, int var3);
    }
}

