/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.common.MapAdaptor;
import org.javimmutable.collections.iterators.TransformStreamable;

@Immutable
public abstract class AbstractJImmutableMap<K, V>
implements JImmutableMap<K, V> {
    @Override
    @Nullable
    public V get(K key) {
        return this.getValueOr(key, null);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> insert(@Nonnull JImmutableMap.Entry<? extends K, ? extends V> e) {
        return this.assign(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull JImmutableMap<? extends K, ? extends V> map) {
        return map.reduce(this, (R m, K k, V v) -> {
            m = m.assign(k, v);
            return m;
        });
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assignAll(@Nonnull Map<? extends K, ? extends V> map) {
        JImmutableMap<K, V> answer = this;
        for (Map.Entry<K, V> e : map.entrySet()) {
            answer = answer.assign(e.getKey(), e.getValue());
        }
        return answer;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isNonEmpty() {
        return this.size() != 0;
    }

    @Override
    @Nonnull
    public Map<K, V> getMap() {
        return MapAdaptor.of(this);
    }

    @Override
    @Nonnull
    public IterableStreamable<K> keys() {
        return TransformStreamable.ofKeys(this);
    }

    @Override
    @Nonnull
    public IterableStreamable<V> values() {
        return TransformStreamable.ofValues(this);
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JImmutableMap) {
            return this.getMap().equals(((JImmutableMap)o).getMap());
        }
        return o instanceof Map && this.getMap().equals(o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.forEach((K k, V v) -> {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            MapEntry.addToString(sb, k, v);
        });
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1024;
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> select(@Nonnull BiPredicate<K, V> predicate) {
        return this.reduce(this.deleteAll().mapBuilder(), (R b, K k, V v) -> predicate.test(k, v) ? b.add(k, v) : b).build();
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> reject(@Nonnull BiPredicate<K, V> predicate) {
        return this.reduce(this, (R m, K k, V v) -> predicate.test(k, v) ? m.delete(k) : m);
    }
}

