/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableMultiset;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.Conditions;
import org.javimmutable.collections.common.SetAdaptor;
import org.javimmutable.collections.indexed.IndexedHelper;
import org.javimmutable.collections.iterators.IndexedIterator;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.iterators.LazyMultiIterator;

@Immutable
public abstract class AbstractJImmutableMultiset<T>
implements JImmutableMultiset<T> {
    protected final JImmutableMap<T, Integer> map;
    protected final int occurrences;

    protected AbstractJImmutableMultiset(JImmutableMap<T, Integer> map, int occurrences) {
        this.map = map;
        this.occurrences = occurrences;
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> insert(@Nonnull T value) {
        return new Editor().delta(value, 1).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> insert(@Nonnull T value, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return this;
        }
        return new Editor().delta(value, count).build();
    }

    @Override
    @Nonnull
    public JImmutableSet<T> getInsertableSelf() {
        return this;
    }

    @Override
    public boolean contains(@Nullable T value) {
        return value != null && this.count(value) > 0;
    }

    @Override
    public boolean containsAtLeast(@Nullable T value, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        return value != null && this.count(value) >= count;
    }

    @Override
    public boolean containsAll(@Nonnull Iterable<? extends T> other) {
        return this.containsAll(other.iterator());
    }

    @Override
    public boolean containsAll(@Nonnull Iterator<? extends T> other) {
        while (other.hasNext()) {
            if (this.contains(other.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAllOccurrences(@Nonnull Iterable<? extends T> other) {
        return this.containsAllOccurrences(other.iterator());
    }

    @Override
    public boolean containsAllOccurrences(@Nonnull Iterator<? extends T> other) {
        Counter counter = new Counter();
        while (other.hasNext()) {
            T value = other.next();
            if (value != null && counter.add(value, 1) <= this.count(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAllOccurrences(@Nonnull JImmutableMultiset<? extends T> values) {
        return this.containsAllOccurrencesMultisetHelper(values);
    }

    @Override
    public boolean containsAny(@Nonnull Iterable<? extends T> other) {
        return this.containsAny(other.iterator());
    }

    @Override
    public boolean containsAny(@Nonnull Iterator<? extends T> other) {
        while (other.hasNext()) {
            if (!this.contains(other.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> delete(@Nonnull T value) {
        return new Editor().remove(value).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteOccurrence(@Nonnull T value) {
        return new Editor().delta(value, -1).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteOccurrence(@Nonnull T value, int subtractBy) {
        if (subtractBy < 0) {
            throw new IllegalArgumentException();
        }
        return new Editor().delta(value, -subtractBy).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteAll(@Nonnull Iterable<? extends T> other) {
        return this.deleteAll((Iterator)other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteAll(@Nonnull Iterator<? extends T> other) {
        Editor editor = new Editor();
        while (other.hasNext()) {
            T value = other.next();
            if (value == null) continue;
            editor.remove(value);
        }
        return editor.build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteAllOccurrences(@Nonnull Iterable<? extends T> other) {
        return this.deleteAllOccurrences(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteAllOccurrences(@Nonnull Iterator<? extends T> other) {
        Editor editor = new Editor();
        while (other.hasNext()) {
            T value = other.next();
            if (value == null) continue;
            editor.delta(value, -1);
        }
        return editor.build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> deleteAllOccurrences(@Nonnull JImmutableMultiset<? extends T> other) {
        return this.deleteAllOccurrencesMultisetHelper(other);
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> insertAll(@Nonnull Iterable<? extends T> values) {
        return this.insertAll((Iterator)values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> insertAll(@Nonnull Iterator<? extends T> other) {
        Editor editor = new Editor();
        while (other.hasNext()) {
            T value = other.next();
            if (value == null) continue;
            editor.delta(value, 1);
        }
        return editor.build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> insertAll(@Nonnull JImmutableMultiset<? extends T> values) {
        return this.insertAllMultisetHelper(values);
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> union(@Nonnull Iterable<? extends T> other) {
        return this.union((Iterator)other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> union(@Nonnull Iterator<? extends T> other) {
        Counter counter = new Counter(other);
        return new Editor().max(counter).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> union(@Nonnull JImmutableMultiset<? extends T> other) {
        return this.unionMultisetHelper(other);
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> intersection(@Nonnull Iterable<? extends T> other) {
        return this.intersection((Iterator)other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> intersection(@Nonnull Iterator<? extends T> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (!other.hasNext()) {
            return this.deleteAll();
        }
        Counter counter = new Counter(other);
        return new Editor().min(counter).removeValuesNotInCounter(counter).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> intersection(@Nonnull JImmutableMultiset<? extends T> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this.deleteAll();
        }
        Counter counter = new Counter(other.entries());
        return new Editor().min(counter).removeValuesNotInCounter(counter).build();
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> intersection(@Nonnull JImmutableSet<? extends T> other) {
        return this.intersection((Set)other.getSet());
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> intersection(@Nonnull Set<? extends T> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this.deleteAll();
        }
        Editor editor = new Editor();
        for (JImmutableMap.Entry entry : this.map) {
            Object value = entry.getKey();
            int oldCount = (Integer)entry.getValue();
            if (other.contains(value)) {
                editor.adjust(value, oldCount, 1);
                continue;
            }
            editor.adjust(value, oldCount, 0);
        }
        return editor.build();
    }

    @Override
    public int count(@Nonnull T value) {
        Conditions.stopNull(value);
        return this.map.getValueOr(value, 0);
    }

    @Override
    @Nonnull
    public JImmutableMultiset<T> setCount(@Nonnull T value, int count) {
        Conditions.stopNull(value, count);
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        return new Editor().set(value, count).build();
    }

    protected abstract JImmutableMultiset<T> create(JImmutableMap<T, Integer> var1, int var2);

    protected abstract Map<T, Integer> emptyMutableMap();

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int occurrenceCount() {
        return this.occurrences;
    }

    @Override
    @Nonnull
    public Set<T> getSet() {
        return SetAdaptor.of(this);
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.map.keys().iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return this.map.getSpliteratorCharacteristics();
    }

    @Override
    @Nonnull
    public IterableStreamable<JImmutableMap.Entry<T, Integer>> entries() {
        return this.map;
    }

    @Override
    @Nonnull
    public IterableStreamable<T> occurrences() {
        return new IterableStreamable<T>(){

            @Override
            @Nonnull
            public SplitableIterator<T> iterator() {
                return LazyMultiIterator.transformed(AbstractJImmutableMultiset.this.map.iterator(), e -> () -> IndexedIterator.iterator(IndexedHelper.repeating(e.getKey(), (Integer)e.getValue())));
            }

            @Override
            public int getSpliteratorCharacteristics() {
                return AbstractJImmutableMultiset.this.map.getSpliteratorCharacteristics();
            }
        };
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof JImmutableMultiset) {
            JImmutableMultiset that = (JImmutableMultiset)o;
            return this.occurrenceCount() == that.occurrenceCount() && this.containsAllOccurrences(that);
        }
        if (o instanceof JImmutableSet) {
            JImmutableSet that = (JImmutableSet)o;
            return this.size() == this.occurrences && this.getSet().equals(that.getSet());
        }
        return o instanceof Set && this.size() == this.occurrences && this.getSet().equals(o);
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.occurrences().iterator());
    }

    @Override
    public void checkInvariants() {
        this.map.checkInvariants();
        if (this.occurrences < this.map.size()) {
            throw new IllegalStateException();
        }
        int checkOccurrences = 0;
        for (JImmutableMap.Entry entry : this.entries()) {
            int entryCount = (Integer)entry.getValue();
            if (entryCount <= 0) {
                throw new IllegalStateException(String.format("illegal count of %d for value %s%n", entryCount, entry.getKey()));
            }
            checkOccurrences += entryCount;
        }
        if (this.occurrences != checkOccurrences) {
            throw new RuntimeException(String.format("occurrence size mismatch - expected %d found %d%n", checkOccurrences, this.occurrences));
        }
    }

    private <T1 extends T> boolean containsAllOccurrencesMultisetHelper(@Nonnull JImmutableMultiset<T1> values) {
        for (JImmutableMap.Entry entry : values.entries()) {
            Object value = entry.getKey();
            int otherCount = (Integer)entry.getValue();
            if (this.count(value) >= otherCount) continue;
            return false;
        }
        return true;
    }

    private <T1 extends T> JImmutableMultiset<T> deleteAllOccurrencesMultisetHelper(@Nonnull JImmutableMultiset<T1> values) {
        Editor editor = new Editor();
        for (JImmutableMap.Entry entry : values.entries()) {
            Object value = entry.getKey();
            int otherCount = (Integer)entry.getValue();
            editor.delta(value, -otherCount);
        }
        return editor.build();
    }

    private <T1 extends T> JImmutableMultiset<T> insertAllMultisetHelper(@Nonnull JImmutableMultiset<T1> values) {
        Editor editor = new Editor();
        for (JImmutableMap.Entry entry : values.entries()) {
            Object value = entry.getKey();
            int otherCount = (Integer)entry.getValue();
            editor.delta(value, otherCount);
        }
        return editor.build();
    }

    @Nonnull
    private <T1 extends T> JImmutableMultiset<T> unionMultisetHelper(@Nonnull JImmutableMultiset<T1> other) {
        Editor editor = new Editor();
        for (JImmutableMap.Entry entry : other.entries()) {
            Object value = entry.getKey();
            int otherCount = (Integer)entry.getValue();
            editor.set(value, Math.max(otherCount, this.count(value)));
        }
        return editor.build();
    }

    private class Counter {
        private final Map<T, Integer> counts;

        private Counter() {
            this.counts = AbstractJImmutableMultiset.this.emptyMutableMap();
            assert (this.counts.isEmpty());
        }

        private Counter(Iterator<? extends T> values) {
            this();
            while (values.hasNext()) {
                Object value = values.next();
                if (value == null) continue;
                this.add(value, 1);
            }
        }

        private <T1 extends T> Counter(IterableStreamable<JImmutableMap.Entry<T1, Integer>> values) {
            this();
            for (JImmutableMap.Entry entry : values) {
                this.add(entry.getKey(), (Integer)entry.getValue());
            }
        }

        private int add(T value, int number) {
            assert (value != null);
            assert (number > 0);
            int currentCount = this.get(value);
            int newCount = currentCount + number;
            this.counts.put(value, newCount);
            return newCount;
        }

        private int get(T value) {
            assert (value != null);
            Integer count = this.counts.get(value);
            assert (count == null || count > 0);
            return count == null ? 0 : count;
        }

        void forEach(@Nonnull BiConsumer<T, Integer> proc) {
            this.counts.forEach(proc);
        }
    }

    private class Editor {
        private JImmutableMap<T, Integer> newMap;
        private int newOccurrences;

        private Editor() {
            this.newMap = AbstractJImmutableMultiset.this.map;
            this.newOccurrences = AbstractJImmutableMultiset.this.occurrences;
        }

        private Editor remove(T value) {
            return this.set(value, 0);
        }

        private Editor delta(T value, int delta) {
            int oldCount = this.newMap.getValueOr(value, 0);
            this.adjust(value, oldCount, oldCount + delta);
            return this;
        }

        private Editor set(T value, int newCount) {
            int oldCount = this.newMap.getValueOr(value, 0);
            this.adjust(value, oldCount, newCount);
            return this;
        }

        private Editor max(Counter counter) {
            counter.forEach((value, count) -> {
                int ourCount = this.newMap.getValueOr(value, 0);
                int theirCount = count;
                this.adjust(value, ourCount, Math.max(ourCount, theirCount));
            });
            return this;
        }

        private Editor min(Counter counter) {
            counter.forEach((value, count) -> {
                int ourCount = this.newMap.getValueOr(value, 0);
                int theirCount = count;
                this.adjust(value, ourCount, Math.min(ourCount, theirCount));
            });
            return this;
        }

        private void adjust(T value, int oldCount, int newCount) {
            if (newCount != oldCount) {
                if (newCount <= 0) {
                    this.newMap = this.newMap.delete(value);
                    this.newOccurrences -= oldCount;
                } else {
                    this.newMap = this.newMap.assign(value, newCount);
                    this.newOccurrences = this.newOccurrences - oldCount + newCount;
                }
            }
        }

        private Editor removeValuesNotInCounter(Counter counter) {
            this.newMap.forEach((value, count) -> {
                if (counter.get(value) == 0) {
                    this.newMap = this.newMap.delete(value);
                    this.newOccurrences -= count.intValue();
                }
            });
            return this;
        }

        private JImmutableMultiset<T> build() {
            if (this.newMap == AbstractJImmutableMultiset.this.map) {
                return AbstractJImmutableMultiset.this;
            }
            if (this.newMap.isEmpty()) {
                return AbstractJImmutableMultiset.this.deleteAll();
            }
            return AbstractJImmutableMultiset.this.create(this.newMap, this.newOccurrences);
        }
    }
}

