/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableMultiset;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.common.SetAdaptor;
import org.javimmutable.collections.iterators.IteratorHelper;

@Immutable
public abstract class AbstractJImmutableSet<T>
implements JImmutableSet<T> {
    @Override
    @Nonnull
    public JImmutableSet<T> getInsertableSelf() {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Iterable<? extends T> values) {
        return this.union(values.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insertAll(@Nonnull Iterator<? extends T> values) {
        return this.union(values);
    }

    @Override
    public boolean containsAll(@Nonnull Iterable<? extends T> values) {
        return this.containsAll(values.iterator());
    }

    @Override
    public boolean containsAll(@Nonnull Iterator<? extends T> values) {
        while (values.hasNext()) {
            if (this.contains(values.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAny(@Nonnull Iterable<? extends T> values) {
        return this.containsAny(values.iterator());
    }

    @Override
    public boolean containsAny(@Nonnull Iterator<? extends T> values) {
        while (values.hasNext()) {
            if (!this.contains(values.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterable<? extends T> other) {
        return this.deleteAll(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterable<? extends T> other) {
        return this.union(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterable<? extends T> other) {
        return this.intersection(other.iterator());
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull JImmutableSet<? extends T> other) {
        return this.intersection(other.getSet());
    }

    @Override
    @Nonnull
    public Set<T> getSet() {
        return SetAdaptor.of(this);
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof JImmutableMultiset) {
            return o.equals(this);
        }
        if (o instanceof JImmutableSet) {
            return this.getSet().equals(((JImmutableSet)o).getSet());
        }
        return o instanceof Set && this.getSet().equals(o);
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    protected abstract Set<T> emptyMutableSet();
}

