/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.AbstractJImmutableSet;

public abstract class AbstractJImmutableSetUsingMap<T>
extends AbstractJImmutableSet<T> {
    protected final JImmutableMap<T, Boolean> map;

    public AbstractJImmutableSetUsingMap(@Nonnull JImmutableMap<T, Boolean> map) {
        this.map = map;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insert(@Nonnull T value) {
        JImmutableMap<T, Boolean> newMap = this.map.assign(value, Boolean.TRUE);
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    public boolean contains(@Nullable T value) {
        return value != null && this.map.getValueOr(value, Boolean.FALSE) != false;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> delete(T value) {
        JImmutableMap<T, Boolean> newMap = this.map.delete(value);
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterator<? extends T> values) {
        JImmutableMap<T, Boolean> newMap = this.map;
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            newMap = newMap.delete(value);
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterator<? extends T> values) {
        JImmutableMap<T, Boolean> newMap = this.map;
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            newMap = newMap.assign(value, Boolean.TRUE);
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterator<? extends T> values) {
        if (this.isEmpty()) {
            return this;
        }
        if (!values.hasNext()) {
            return this.deleteAll();
        }
        Set otherSet = this.emptyMutableSet();
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            otherSet.add(value);
        }
        JImmutableMap<T, Boolean> newMap = this.map;
        for (JImmutableMap.Entry entry : this.map) {
            if (otherSet.contains(entry.getKey())) continue;
            newMap = newMap.delete(entry.getKey());
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Set<? extends T> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this.deleteAll();
        }
        JImmutableMap<T, Boolean> newMap = this.map;
        for (Object value : this.map.keys()) {
            if (other.contains(value)) continue;
            newMap = newMap.delete(value);
        }
        return newMap != this.map ? this.create(newMap) : this;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.map.keys().iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return this.map.keys().getSpliteratorCharacteristics();
    }

    @Override
    public void checkInvariants() {
        this.checkSetInvariants();
    }

    protected void checkSetInvariants() {
        this.map.checkInvariants();
        for (JImmutableMap.Entry entry : this.map) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            throw new RuntimeException();
        }
    }

    protected abstract JImmutableSet<T> create(JImmutableMap<T, Boolean> var1);
}

