/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.lang.reflect.Array;
import javax.annotation.Nonnull;

public final class ArrayHelper {
    @Nonnull
    public static <T> T[] subArray(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int offset, int limit) {
        int length = limit - offset;
        T[] answer = allocator.allocate(length);
        System.arraycopy(orig, offset, answer, 0, length);
        return answer;
    }

    @Nonnull
    public static <T> T[] subArray(@Nonnull Allocator<T> allocator, @Nonnull T[] a, @Nonnull T[] b, int offset, int limit) {
        int length = limit - offset;
        T[] answer = allocator.allocate(length);
        if (offset > a.length) {
            System.arraycopy(b, offset - a.length, answer, 0, length);
        } else if (limit <= a.length) {
            System.arraycopy(a, offset, answer, 0, length);
        } else {
            int alength = a.length - offset;
            System.arraycopy(a, offset, answer, 0, alength);
            System.arraycopy(b, 0, answer, alength, length - alength);
        }
        return answer;
    }

    @Nonnull
    public static <T> T[] assign(@Nonnull T[] orig, int index, T value) {
        Object[] answer = (Object[])orig.clone();
        answer[index] = value;
        return answer;
    }

    @Nonnull
    public static <T> T[] append(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, T value) {
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, orig.length);
        answer[orig.length] = value;
        return answer;
    }

    @Nonnull
    public static <T> T[] insert(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index, T value) {
        if (index == orig.length) {
            return ArrayHelper.append(allocator, orig, value);
        }
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index, answer, index + 1, orig.length - index);
        answer[index] = value;
        return answer;
    }

    @Nonnull
    public static <T> T[] insert(@Nonnull T[] orig, int index, T value) {
        return ArrayHelper.insert(ArrayHelper::allocate, orig, index, value);
    }

    @Nonnull
    public static <T> T[] delete(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index) {
        T[] answer = allocator.allocate(orig.length - 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index + 1, answer, index, orig.length - index - 1);
        return answer;
    }

    @Nonnull
    public static <T> T[] delete(@Nonnull T[] orig, int index) {
        return ArrayHelper.delete(ArrayHelper::allocate, orig, index);
    }

    @Nonnull
    public static <T> T[] concat(@Nonnull Allocator<T> allocator, @Nonnull T[] a, @Nonnull T[] b) {
        T[] answer = allocator.allocate(a.length + b.length);
        System.arraycopy(a, 0, answer, 0, a.length);
        System.arraycopy(b, 0, answer, a.length, b.length);
        return answer;
    }

    @Nonnull
    public static <T> T[] assignAppend(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, T assignValue, T appendValue) {
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, orig.length - 1);
        answer[orig.length - 1] = assignValue;
        answer[orig.length] = appendValue;
        return answer;
    }

    @Nonnull
    public static <T> T[] assignTwo(@Nonnull T[] orig, int index, T first, T second) {
        Object[] answer = (Object[])orig.clone();
        answer[index] = first;
        answer[index + 1] = second;
        return answer;
    }

    @Nonnull
    public static <T> T[] assignInsert(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index, T assignValue, T insertValue) {
        T[] answer = allocator.allocate(orig.length + 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index, answer, index + 1, orig.length - index);
        answer[index] = assignValue;
        answer[index + 1] = insertValue;
        return answer;
    }

    @Nonnull
    public static <T> T[] assignDelete(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int index, T newNode) {
        T[] answer = allocator.allocate(orig.length - 1);
        System.arraycopy(orig, 0, answer, 0, index);
        System.arraycopy(orig, index + 1, answer, index, orig.length - index - 1);
        answer[index] = newNode;
        return answer;
    }

    @Nonnull
    public static <T> T[] prefix(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int limit) {
        T[] answer = allocator.allocate(limit);
        System.arraycopy(orig, 0, answer, 0, limit);
        return answer;
    }

    @Nonnull
    public static <T> T[] prefixInsert(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int limit, int index, T value) {
        T[] answer = allocator.allocate(limit + 1);
        System.arraycopy(orig, 0, answer, 0, index);
        answer[index] = value;
        System.arraycopy(orig, index, answer, index + 1, limit - index);
        return answer;
    }

    @Nonnull
    public static <T> T[] suffix(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int offset) {
        try {
            int length = orig.length - offset;
            T[] answer = allocator.allocate(length);
            System.arraycopy(orig, offset, answer, 0, length);
            return answer;
        }
        catch (NegativeArraySizeException ex) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
    }

    @Nonnull
    public static <T> T[] suffixInsert(@Nonnull Allocator<T> allocator, @Nonnull T[] orig, int offset, int index, T value) {
        int length = orig.length - offset;
        int answerIndex = index - offset;
        T[] answer = allocator.allocate(length + 1);
        System.arraycopy(orig, offset, answer, 0, answerIndex);
        answer[answerIndex] = value;
        System.arraycopy(orig, index, answer, answerIndex + 1, length - answerIndex);
        return answer;
    }

    @Nonnull
    public static <T> T[] reverse(@Nonnull Allocator<T> allocator, @Nonnull T[] orig) {
        int length = orig.length;
        if (length == 0) {
            return orig;
        }
        T[] answer = allocator.allocate(length);
        int from = 0;
        for (int to = length - 1; to >= 0; --to) {
            answer[to] = orig[from];
            ++from;
        }
        return answer;
    }

    @Nonnull
    public static <T> Allocator<T> allocator(final Class<T> klass) {
        return new Allocator<T>(){

            @Override
            @Nonnull
            public T[] allocate(int size) {
                return (Object[])Array.newInstance(klass, size);
            }
        };
    }

    public static <T> void checkBounds(T[] values, int index) {
        if (index < 0 || index >= values.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public static <T> T[] allocate(int size) {
        return new Object[size];
    }

    public static <T> T[] newArray(T a) {
        T[] answer = ArrayHelper.allocate(1);
        answer[0] = a;
        return answer;
    }

    public static <T> T[] newArray(T a, T b) {
        T[] answer = ArrayHelper.allocate(2);
        answer[0] = a;
        answer[1] = b;
        return answer;
    }

    public static interface Allocator<T> {
        @Nonnull
        public T[] allocate(int var1);
    }
}

