/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.function.Function;
import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.Temp;

public final class BitmaskMath {
    public static final int ARRAY_SIZE = 64;
    public static final int MAX_INDEX = 63;
    public static final long ALL_BITS = -1L;

    private BitmaskMath() {
    }

    public static long bitFromIndex(int index) {
        return 1L << index;
    }

    public static boolean bitIsAbsent(long bitmask, long bit) {
        return (bitmask & bit) == 0L;
    }

    public static boolean bitIsPresent(long bitmask, long bit) {
        return (bitmask & bit) != 0L;
    }

    public static long addBit(long bitmask, long bit) {
        return bitmask | bit;
    }

    public static long removeBit(long bitmask, long bit) {
        return bitmask & (bit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long leastBit(long bitmask) {
        return Long.lowestOneBit(bitmask);
    }

    public static int indexForBit(long bit) {
        return Long.numberOfTrailingZeros(bit);
    }

    public static int arrayIndexForBit(long bitmask, long bit) {
        return Long.bitCount(bitmask & bit - 1L);
    }

    public static int bitCount(long bitmask) {
        return Long.bitCount(bitmask);
    }

    @Nonnull
    public static Indexed<Integer> indices(long bitmask) {
        return new Indexes(bitmask);
    }

    public static void forEachIndex(long bitmask, IntConsumer proc) {
        while (bitmask != 0L) {
            long bit = BitmaskMath.leastBit(bitmask);
            proc.accept(BitmaskMath.indexForBit(bit));
            bitmask = BitmaskMath.removeBit(bitmask, bit);
        }
    }

    public static <S, D> void copyToCompactArrayUsingBitmask(long bitmask, @Nonnull S[] source, @Nonnull D[] dest, @Nonnull Function<S, D> transforminator) {
        assert (dest.length == BitmaskMath.bitCount(bitmask));
        Temp.Int1 destIndex = Temp.intVar(0);
        BitmaskMath.forEachIndex(bitmask, sourceIndex -> {
            dest[destIndex.a] = transforminator.apply(source[sourceIndex]);
            ++destIndex.a;
        });
        assert (destIndex.a == dest.length);
    }

    public static long bitmask(int ... indices) {
        long answer = 0L;
        for (int index : indices) {
            answer |= BitmaskMath.bitFromIndex(index);
        }
        return answer;
    }

    private static class Indexes
    implements Indexed<Integer> {
        private final long bitmask;

        private Indexes(long bitmask) {
            this.bitmask = bitmask;
        }

        @Override
        public Integer get(int index) {
            long remaining = this.bitmask;
            while (index > 0) {
                remaining &= Long.lowestOneBit(remaining) ^ 0xFFFFFFFFFFFFFFFFL;
                --index;
            }
            long bit = Long.lowestOneBit(remaining);
            if (bit == 0L) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return BitmaskMath.indexForBit(bit);
        }

        @Override
        public int size() {
            return BitmaskMath.bitCount(this.bitmask);
        }
    }
}

