/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import javax.annotation.Nonnull;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;

public class GenericSetBuilder<T>
implements JImmutableSet.Builder<T> {
    private final JImmutableMap.Builder<T, Boolean> mapBuilder;
    private final Func1<JImmutableMap<T, Boolean>, JImmutableSet<T>> setFactory;

    public GenericSetBuilder(JImmutableMap.Builder<T, Boolean> mapBuilder, Func1<JImmutableMap<T, Boolean>, JImmutableSet<T>> setFactory) {
        this.mapBuilder = mapBuilder;
        this.setFactory = setFactory;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> build() {
        return this.setFactory.apply(this.mapBuilder.build());
    }

    @Override
    @Nonnull
    public JImmutableSet.Builder<T> clear() {
        this.mapBuilder.clear();
        return this;
    }

    @Override
    public int size() {
        return this.mapBuilder.size();
    }

    @Override
    @Nonnull
    public JImmutableSet.Builder<T> add(T value) {
        this.mapBuilder.add(value, Boolean.TRUE);
        return this;
    }
}

