/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import javax.annotation.Nonnull;

public final class IntArrayMappedTrieMath {
    public static final int MAX_SHIFTS = IntArrayMappedTrieMath.maxShiftsForBitCount(32);
    public static final int MAX_FULL_SHIFTS = IntArrayMappedTrieMath.maxShiftsForBitCount(30);
    public static final int MAX_SHIFT_NUMBER = MAX_SHIFTS - 1;
    public static final int MAX_FULL_SHIFT_NUMBER = MAX_SHIFT_NUMBER - 1;
    private static final int SHIFT = 6;
    private static final int MASK = 63;
    private static final int BASE_INDEX_MASK = -64;

    private IntArrayMappedTrieMath() {
    }

    public static int baseIndexFromHashCode(int hashCode) {
        return hashCode & 0xFFFFFFC0;
    }

    public static int remainderFromHashCode(int hashCode) {
        return hashCode >>> 6;
    }

    public static int findMaxCommonShift(int maxAllowedShift, int hashCode1, int hashCode2) {
        assert (maxAllowedShift >= 0);
        assert (maxAllowedShift < MAX_SHIFTS);
        for (int shift = maxAllowedShift; shift > 0; --shift) {
            int index2;
            int index1 = IntArrayMappedTrieMath.indexAtShift(shift, hashCode1);
            if (index1 == (index2 = IntArrayMappedTrieMath.indexAtShift(shift, hashCode2))) continue;
            return shift;
        }
        return 0;
    }

    public static int indexFromHashCode(int hashCode) {
        return hashCode & 0x3F;
    }

    public static int liftedHashCode(int hashCode, int index) {
        return hashCode << 6 | index;
    }

    public static int maxShiftsForBitCount(int bitCount) {
        return (bitCount + 6 - 1) / 6;
    }

    public static int indexAtShift(int shiftCount, int hashCode) {
        return hashCode >>> shiftCount * 6 & 0x3F;
    }

    public static int baseIndexAtShift(int shiftCount, int hashCode) {
        return shiftCount > MAX_FULL_SHIFT_NUMBER ? 0 : hashCode & -1 << 6 * (1 + shiftCount);
    }

    public static int hashCodeBelowShift(int shiftCount, int hashCode) {
        return hashCode & (1 << shiftCount * 6) - 1;
    }

    public static int findMinimumShiftForZeroBelowHashCode(int hashCode) {
        int bitNumber = hashCode == 0 ? 1 : Integer.numberOfTrailingZeros(Integer.lowestOneBit(hashCode));
        return bitNumber / 6;
    }

    public static int shift(int shiftCount, int value) {
        return value << shiftCount * 6;
    }

    public static int hash(int shift5, int shift4, int shift3, int shift2, int shift1, int shift0) {
        int answer = shift5 << 6 | shift4;
        answer = answer << 6 | shift3;
        answer = answer << 6 | shift2;
        answer = answer << 6 | shift1;
        return answer << 6 | shift0;
    }

    @Nonnull
    public static String hashString(int hashCode) {
        StringBuilder sb = new StringBuilder();
        for (int shiftCount = MAX_SHIFT_NUMBER; shiftCount >= 0; --shiftCount) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(IntArrayMappedTrieMath.indexAtShift(shiftCount, hashCode));
        }
        return sb.toString();
    }
}

