/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import javax.annotation.Nonnull;

public final class LongArrayMappedTrieMath {
    public static final int MAX_SHIFTS = LongArrayMappedTrieMath.maxShiftsForBitCount(64);
    public static final int MAX_FULL_SHIFTS = LongArrayMappedTrieMath.maxShiftsForBitCount(60);
    public static final int MAX_SHIFT_NUMBER = MAX_SHIFTS - 1;
    public static final int MAX_FULL_SHIFT_NUMBER = MAX_SHIFT_NUMBER - 1;
    private static final int SHIFT = 6;
    private static final long MASK = 63L;
    private static final long BASE_INDEX_MASK = -64L;

    private LongArrayMappedTrieMath() {
    }

    public static long baseIndexFromHashCode(long hashCode) {
        return hashCode & 0xFFFFFFFFFFFFFFC0L;
    }

    public static long remainderFromHashCode(long hashCode) {
        return hashCode >>> 6;
    }

    public static int findMaxCommonShift(int maxAllowedShift, long hashCode1, long hashCode2) {
        assert (maxAllowedShift >= 0);
        assert (maxAllowedShift < MAX_SHIFTS);
        for (int shift = maxAllowedShift; shift > 0; --shift) {
            long index2;
            long index1 = LongArrayMappedTrieMath.indexAtShift(shift, hashCode1);
            if (index1 == (index2 = (long)LongArrayMappedTrieMath.indexAtShift(shift, hashCode2))) continue;
            return shift;
        }
        return 0;
    }

    public static int indexFromHashCode(long hashCode) {
        return (int)(hashCode & 0x3FL);
    }

    public static long liftedHashCode(long hashCode, int index) {
        return hashCode << 6 | (long)index;
    }

    public static int maxShiftsForBitCount(int bitCount) {
        return (bitCount + 6 - 1) / 6;
    }

    public static int indexAtShift(int shiftCount, long hashCode) {
        return (int)(hashCode >>> shiftCount * 6 & 0x3FL);
    }

    public static long baseIndexAtShift(int shiftCount, long hashCode) {
        return shiftCount > MAX_FULL_SHIFT_NUMBER ? 0L : hashCode & -1L << 6 * (1 + shiftCount);
    }

    public static long withIndexAtShift(int shiftCount, long hashCode, int index) {
        int shift = shiftCount * 6;
        long mask = 63L << shift;
        long bits = (long)index << shift;
        return hashCode & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
    }

    public static long hashCodeBelowShift(int shiftCount, long hashCode) {
        return hashCode & (1L << shiftCount * 6) - 1L;
    }

    public static int findMinimumShiftForZeroBelowHashCode(long hashCode) {
        int bitNumber = hashCode == 0L ? 1 : Long.numberOfTrailingZeros(Long.lowestOneBit(hashCode));
        return bitNumber / 6;
    }

    public static int findMaxShiftForHashCode(long hashCode) {
        int bitNumber = hashCode == 0L ? 1 : Long.numberOfTrailingZeros(Long.highestOneBit(hashCode));
        return bitNumber / 6;
    }

    public static long shift(int shiftCount, long value) {
        return value << shiftCount * 6;
    }

    public static long hash(int ... values) {
        assert (values.length <= MAX_SHIFTS);
        long value = 0L;
        boolean started = false;
        for (int v : values) {
            if (!started && v == 0) continue;
            value = LongArrayMappedTrieMath.liftedHashCode(value, v);
            started = true;
        }
        return value;
    }

    @Nonnull
    public static String hashString(long hashCode) {
        StringBuilder sb = new StringBuilder();
        for (int shiftCount = MAX_SHIFT_NUMBER; shiftCount >= 0; --shiftCount) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(LongArrayMappedTrieMath.indexAtShift(shiftCount, hashCode));
        }
        return sb.toString();
    }
}

