/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.iterators.TransformStreamable;

@Immutable
public class MapAdaptor<K, V>
extends AbstractMap<K, V> {
    private final JImmutableMap<K, V> map;

    public MapAdaptor(JImmutableMap<K, V> map) {
        this.map = map;
    }

    public static <K, V> MapAdaptor<K, V> of(JImmutableMap<K, V> map) {
        return new MapAdaptor<K, V>(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.find(o).isFilled();
    }

    @Override
    public boolean containsValue(Object o) {
        for (JImmutableMap.Entry entry : this.map) {
            Object value = entry.getValue();
            if (!(o == null ? value == null : value != null && value.equals(o))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object o) {
        return this.map.getValueOr(o, null);
    }

    @Override
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public boolean isEmpty() {
                return MapAdaptor.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return MapAdaptor.this.map.find(o).isFilled();
            }

            @Override
            public Iterator<K> iterator() {
                return MapAdaptor.this.map.keys().iterator();
            }

            @Override
            public Spliterator<K> spliterator() {
                return MapAdaptor.this.map.keys().spliterator();
            }

            @Override
            public int size() {
                return MapAdaptor.this.map.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return MapAdaptor.this.map.values().iterator();
            }

            @Override
            public Spliterator<V> spliterator() {
                return MapAdaptor.this.map.values().spliterator();
            }

            @Override
            public int size() {
                return MapAdaptor.this.map.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public boolean isEmpty() {
                return MapAdaptor.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry oEntry = (Map.Entry)o;
                Holder eHolder = MapAdaptor.this.map.findEntry(oEntry.getKey());
                return eHolder.isFilled() && new MapEntry(eHolder.getValue()).equals(oEntry);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return this.streamable().iterator();
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return this.streamable().spliterator();
            }

            @Override
            public int size() {
                return MapAdaptor.this.map.size();
            }

            @Nonnull
            private IterableStreamable<Map.Entry<K, V>> streamable() {
                return TransformStreamable.of(MapAdaptor.this.map, e -> MapEntry.of(e));
            }
        };
    }
}

