/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.common;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableSet;

@Immutable
public class SetAdaptor<T>
extends AbstractSet<T> {
    private final JImmutableSet<T> pset;

    public SetAdaptor(JImmutableSet<T> pset) {
        this.pset = pset;
    }

    public static <T> SetAdaptor<T> of(JImmutableSet<T> pset) {
        return new SetAdaptor<T>(pset);
    }

    @Override
    public boolean contains(Object o) {
        return this.pset.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.pset.iterator();
    }

    @Override
    public int size() {
        return this.pset.size();
    }

    public static <T> boolean areEqual(Set<T> a, Set<T> b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (T value : a) {
            if (b.contains(value)) continue;
            return false;
        }
        return true;
    }
}

