/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.common.AbstractJImmutableSet;
import org.javimmutable.collections.hash.HashSetBuilder;
import org.javimmutable.collections.hash.JImmutableHashSet;
import org.javimmutable.collections.iterators.EmptyIterator;

public class EmptyHashSet<T>
extends AbstractJImmutableSet<T>
implements Serializable {
    private static final EmptyHashSet INSTANCE = new EmptyHashSet();

    public static <T> EmptyHashSet<T> instance() {
        return INSTANCE;
    }

    @Override
    protected Set<T> emptyMutableSet() {
        return new HashSet();
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insert(@Nonnull T value) {
        return new JImmutableHashSet<T>(value);
    }

    @Override
    public boolean contains(@Nullable T value) {
        return false;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> delete(T value) {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterable<? extends T> other) {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterator<? extends T> other) {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterator<? extends T> values) {
        return new HashSetBuilder<Iterator<? extends T>>().add(values).build();
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterable<? extends T> other) {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull JImmutableSet<? extends T> other) {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterator<? extends T> values) {
        return this;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Set<? extends T> other) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll() {
        return this;
    }

    @Override
    public void checkInvariants() {
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return EmptyIterator.of();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1024;
    }
}

