/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.array.ArrayAssignMapper;
import org.javimmutable.collections.array.TrieArrayBuilder;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.hash.JImmutableHashSet;
import org.javimmutable.collections.hash.set.ArraySetNode;
import org.javimmutable.collections.hash.set.ArraySingleValueSetNode;
import org.javimmutable.collections.list.ListCollisionSet;

@ThreadSafe
class HashSetBuilder<T>
implements JImmutableSet.Builder<T>,
ArrayAssignMapper<T, T, ArraySetNode<T>> {
    private final TrieArrayBuilder<ArraySetNode<T>> builder = new TrieArrayBuilder();
    private CollisionSet<T> collisionSet = ListCollisionSet.instance();

    HashSetBuilder() {
    }

    @Override
    @Nonnull
    public synchronized JImmutableSet<T> build() {
        if (this.builder.size() == 0) {
            return JImmutableHashSet.of();
        }
        return new JImmutableHashSet<T>(this.builder.buildRoot(), this.collisionSet);
    }

    @Override
    public synchronized int size() {
        return this.builder.size();
    }

    @Override
    @Nonnull
    public synchronized JImmutableSet.Builder<T> add(T value) {
        if (this.builder.size() == 0) {
            this.collisionSet = JImmutableHashSet.selectCollisionSetForValue(value);
        }
        this.builder.assign(this, value, value);
        return this;
    }

    @Override
    @Nonnull
    public synchronized JImmutableSet.Builder<T> clear() {
        this.collisionSet = ListCollisionSet.instance();
        this.builder.reset();
        return this;
    }

    @Override
    @Nonnull
    public synchronized ArraySetNode<T> mappedAssign(@Nonnull T key, T ignored) {
        assert (key == ignored);
        return new ArraySingleValueSetNode<T>(key);
    }

    @Override
    @Nonnull
    public synchronized ArraySetNode<T> mappedAssign(@Nonnull ArraySetNode<T> current, @Nonnull T key, T ignored) {
        assert (key == ignored);
        return current.insert(this.collisionSet, key);
    }

    @Override
    public synchronized int mappedSize(@Nonnull ArraySetNode<T> mapping) {
        return mapping.size(this.collisionSet);
    }
}

