/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash;

import java.io.Serializable;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.Temp;
import org.javimmutable.collections.array.ArrayAssignMapper;
import org.javimmutable.collections.array.ArrayDeleteMapper;
import org.javimmutable.collections.array.ArrayGetMapper;
import org.javimmutable.collections.array.ArrayIterationMapper;
import org.javimmutable.collections.array.ArrayUpdateMapper;
import org.javimmutable.collections.array.TrieArrayBuilder;
import org.javimmutable.collections.array.TrieArrayNode;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.common.CollisionMap;
import org.javimmutable.collections.hash.EmptyHashMap;
import org.javimmutable.collections.hash.map.ArrayMapNode;
import org.javimmutable.collections.hash.map.ArraySingleValueMapNode;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.ListCollisionMap;
import org.javimmutable.collections.serialization.JImmutableHashMapProxy;
import org.javimmutable.collections.tree.TreeCollisionMap;

@Immutable
public class JImmutableHashMap<T, K, V>
extends AbstractJImmutableMap<K, V>
implements ArrayUpdateMapper<K, V, ArrayMapNode<K, V>>,
ArrayGetMapper<K, V, ArrayMapNode<K, V>>,
ArrayIterationMapper<K, V, ArrayMapNode<K, V>>,
ArrayDeleteMapper<K, ArrayMapNode<K, V>>,
Serializable {
    static final JImmutableHashMap LIST_EMPTY = new JImmutableHashMap(TrieArrayNode.empty(), ListCollisionMap.instance());
    static final JImmutableHashMap TREE_EMPTY = new JImmutableHashMap(TrieArrayNode.empty(), TreeCollisionMap.instance());
    private static final long serialVersionUID = -121805L;
    private final TrieArrayNode<ArrayMapNode<K, V>> root;
    private final CollisionMap<K, V> collisionMap;

    private JImmutableHashMap(TrieArrayNode<ArrayMapNode<K, V>> root, CollisionMap<K, V> collisionMap) {
        this.root = root;
        this.collisionMap = collisionMap;
    }

    public static <K, V> EmptyHashMap<K, V> of() {
        return EmptyHashMap.INSTANCE;
    }

    public static <K, V> JImmutableMap<K, V> of(Class<K> klass) {
        return Comparable.class.isAssignableFrom(klass) ? TREE_EMPTY : LIST_EMPTY;
    }

    public static <K, V> JImmutableMap<K, V> forKey(K key) {
        return key instanceof Comparable ? TREE_EMPTY : LIST_EMPTY;
    }

    public static <K, V> JImmutableMap<K, V> usingList() {
        return LIST_EMPTY;
    }

    public static <K extends Comparable<K>, V> JImmutableMap<K, V> usingTree() {
        return TREE_EMPTY;
    }

    public static <K, V> JImmutableMap.Builder<K, V> builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public JImmutableMap.Builder<K, V> mapBuilder() {
        return JImmutableHashMap.builder();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> createMapCollector() {
        return Collector.of(JImmutableHashMap::builder, (b, v) -> b.add(v), (b1, b2) -> b1.add(b2), b -> b.build(), Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT);
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        return this.root.mappedGetValueOr(this, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        return this.root.mappedFind(this, key);
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        Holder<V> value = this.find(key);
        if (value.isEmpty()) {
            return Holders.of();
        }
        return Holders.of(MapEntry.of(key, value.getValue()));
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> assign(@Nonnull K key, V value) {
        TrieArrayNode<ArrayMapNode<K, V>> newRoot = this.root.mappedAssign(this, key, value);
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableHashMap<T, K, V>(newRoot, this.collisionMap);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> update(@Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        TrieArrayNode<ArrayMapNode<K, V>> newRoot = this.root.mappedUpdate(this, key, generator);
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableHashMap<T, K, V>(newRoot, this.collisionMap);
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> delete(@Nonnull K key) {
        TrieArrayNode<ArrayMapNode<K, V>> newRoot = this.root.mappedDelete(this, key);
        if (newRoot == this.root) {
            return this;
        }
        if (newRoot.isEmpty()) {
            return JImmutableHashMap.of();
        }
        return new JImmutableHashMap<T, K, V>(newRoot, this.collisionMap);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    @Nonnull
    public JImmutableMap<K, V> deleteAll() {
        return JImmutableHashMap.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return this.root.mappedEntries(this).iterator();
    }

    @Override
    public void forEach(@Nonnull Proc2<K, V> proc) {
        this.root.forEach((T node) -> node.forEach(this.collisionMap, proc));
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc2Throws<K, V, E> proc) throws E {
        this.root.forEachThrows((T node) -> node.forEachThrows(this.collisionMap, proc));
    }

    @Override
    public <R> R reduce(R startingSum, @Nonnull Sum2<K, V, R> proc) {
        Temp.Var1<R> sum = Temp.var(startingSum);
        this.forEach((K k, V v) -> {
            sum.x = proc.apply(sum.x, k, v);
        });
        return (R)sum.x;
    }

    @Override
    public <R, E extends Exception> R reduceThrows(R startingSum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        Temp.Var1<R> sum = Temp.var(startingSum);
        this.forEachThrows((K k, V v) -> {
            sum.x = proc.apply(sum.x, k, v);
        });
        return (R)sum.x;
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants(this);
    }

    @Override
    public V mappedGetValueOr(@Nonnull ArrayMapNode<K, V> mapping, @Nonnull K key, V defaultValue) {
        return mapping.getValueOr(this.collisionMap, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> mappedFind(@Nonnull ArrayMapNode<K, V> mapping, @Nonnull K key) {
        return mapping.find(this.collisionMap, key);
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> mappedAssign(@Nonnull K key, V value) {
        return new ArraySingleValueMapNode<K, V>(key, value);
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> mappedAssign(@Nonnull ArrayMapNode<K, V> current, @Nonnull K key, V value) {
        return current.assign(this.collisionMap, key, value);
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> mappedUpdate(@Nonnull ArrayMapNode<K, V> current, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        return current.update(this.collisionMap, key, generator);
    }

    @Override
    @Nullable
    public ArrayMapNode<K, V> mappedDelete(@Nonnull ArrayMapNode<K, V> current, @Nonnull K key) {
        return current.delete(this.collisionMap, key);
    }

    @Override
    public int mappedSize(@Nonnull ArrayMapNode<K, V> mapping) {
        return mapping.size(this.collisionMap);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<K> mappedKeys(@Nonnull ArrayMapNode<K, V> mapping) {
        return mapping.keys(this.collisionMap);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<V> mappedValues(@Nonnull ArrayMapNode<K, V> mapping) {
        return mapping.values(this.collisionMap);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<JImmutableMap.Entry<K, V>> mappedEntries(@Nonnull ArrayMapNode<K, V> mapping) {
        return mapping.entries(this.collisionMap);
    }

    CollisionMap getCollisionMap() {
        return this.collisionMap;
    }

    private Object writeReplace() {
        return new JImmutableHashMapProxy(this);
    }

    @ThreadSafe
    public static class Builder<K, V>
    implements JImmutableMap.Builder<K, V>,
    ArrayAssignMapper<K, V, ArrayMapNode<K, V>> {
        private final TrieArrayBuilder<ArrayMapNode<K, V>> builder = new TrieArrayBuilder();
        private CollisionMap<K, V> collisionMap = ListCollisionMap.instance();

        @Override
        @Nonnull
        public synchronized JImmutableMap<K, V> build() {
            TrieArrayNode<ArrayMapNode<K, V>> root = this.builder.buildRoot();
            if (root.isEmpty()) {
                return JImmutableHashMap.of();
            }
            return new JImmutableHashMap(root, this.collisionMap);
        }

        @Override
        @Nonnull
        public synchronized JImmutableMap.Builder<K, V> clear() {
            this.builder.reset();
            this.collisionMap = ListCollisionMap.instance();
            return this;
        }

        @Override
        @Nonnull
        public synchronized JImmutableMap.Builder<K, V> add(@Nonnull K key, V value) {
            if (this.builder.size() == 0) {
                this.collisionMap = key instanceof Comparable ? TreeCollisionMap.instance() : ListCollisionMap.instance();
            }
            this.builder.assign(this, key, value);
            return this;
        }

        @Override
        public synchronized int size() {
            return this.builder.size();
        }

        @Override
        @Nonnull
        public synchronized ArrayMapNode<K, V> mappedAssign(@Nonnull K key, V value) {
            return new ArraySingleValueMapNode<K, V>(key, value);
        }

        @Override
        @Nonnull
        public synchronized ArrayMapNode<K, V> mappedAssign(@Nonnull ArrayMapNode<K, V> current, @Nonnull K key, V value) {
            return current.assign(this.collisionMap, key, value);
        }

        @Override
        public synchronized int mappedSize(@Nonnull ArrayMapNode<K, V> mapping) {
            return mapping.size(this.collisionMap);
        }
    }
}

