/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.JImmutableSet;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.array.ArrayAssignMapper;
import org.javimmutable.collections.array.ArrayContainsMapper;
import org.javimmutable.collections.array.ArrayDeleteMapper;
import org.javimmutable.collections.array.ArrayIterationMapper;
import org.javimmutable.collections.array.TrieArrayNode;
import org.javimmutable.collections.common.AbstractJImmutableSet;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.hash.EmptyHashSet;
import org.javimmutable.collections.hash.HashSetBuilder;
import org.javimmutable.collections.hash.set.ArraySetNode;
import org.javimmutable.collections.hash.set.ArraySingleValueSetNode;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.ListCollisionSet;
import org.javimmutable.collections.serialization.JImmutableHashSetProxy;
import org.javimmutable.collections.tree.TreeCollisionSet;

@Immutable
public class JImmutableHashSet<T>
extends AbstractJImmutableSet<T>
implements ArrayAssignMapper<T, T, ArraySetNode<T>>,
ArrayContainsMapper<T, ArraySetNode<T>>,
ArrayIterationMapper<T, T, ArraySetNode<T>>,
ArrayDeleteMapper<T, ArraySetNode<T>>,
Serializable {
    private static final long serialVersionUID = -121805L;
    private final TrieArrayNode<ArraySetNode<T>> root;
    private final CollisionSet<T> collisionSet;

    JImmutableHashSet(@Nonnull TrieArrayNode<ArraySetNode<T>> root, @Nonnull CollisionSet<T> collisionSet) {
        this.root = root;
        this.collisionSet = collisionSet;
    }

    JImmutableHashSet(@Nonnull T value) {
        this.root = TrieArrayNode.empty().mappedAssign(this, value, value);
        this.collisionSet = JImmutableHashSet.selectCollisionSetForValue(value);
    }

    public static <T> JImmutableSet<T> of() {
        return EmptyHashSet.instance();
    }

    static <T> JImmutableSet<T> usingList() {
        return new JImmutableHashSet<T>(TrieArrayNode.empty(), ListCollisionSet.instance());
    }

    static <T> JImmutableSet<T> usingTree() {
        return new JImmutableHashSet<T>(TrieArrayNode.empty(), TreeCollisionSet.instance());
    }

    @Nonnull
    public static <T> JImmutableSet.Builder<T> builder() {
        return new HashSetBuilder();
    }

    static <T> CollisionSet<T> selectCollisionSetForValue(@Nonnull T value) {
        if (value instanceof Comparable) {
            return TreeCollisionSet.instance();
        }
        return ListCollisionSet.instance();
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll() {
        return JImmutableHashSet.of();
    }

    @Override
    protected Set<T> emptyMutableSet() {
        return new HashSet();
    }

    @Override
    @Nonnull
    public JImmutableSet<T> insert(@Nonnull T value) {
        return this.createForUpdate(this.root.mappedAssign(this, value, value));
    }

    @Override
    public boolean contains(@Nullable T value) {
        return value != null && this.root.mappedContains(this, value);
    }

    @Override
    @Nonnull
    public JImmutableSet<T> delete(T value) {
        return this.createForDelete(this.root.mappedDelete(this, value));
    }

    @Override
    @Nonnull
    public JImmutableSet<T> deleteAll(@Nonnull Iterator<? extends T> other) {
        TrieArrayNode<ArraySetNode<T>> newRoot = this.root;
        while (other.hasNext()) {
            T value = other.next();
            newRoot = newRoot.mappedDelete(this, value);
        }
        return this.createForDelete(newRoot);
    }

    @Override
    @Nonnull
    public JImmutableSet<T> union(@Nonnull Iterator<? extends T> other) {
        TrieArrayNode<ArraySetNode<T>> newRoot = this.root;
        while (other.hasNext()) {
            T value = other.next();
            newRoot = newRoot.mappedAssign(this, value, value);
        }
        return this.createForUpdate(newRoot);
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Iterator<? extends T> values) {
        if (this.isEmpty()) {
            return this;
        }
        if (!values.hasNext()) {
            return this.deleteAll();
        }
        Set<T> otherSet = this.emptyMutableSet();
        while (values.hasNext()) {
            T value = values.next();
            if (value == null) continue;
            otherSet.add(value);
        }
        return this.intersection(otherSet);
    }

    @Override
    @Nonnull
    public JImmutableSet<T> intersection(@Nonnull Set<? extends T> otherSet) {
        TrieArrayNode<ArraySetNode<T>> newRoot = this.root;
        for (Object value : this.root.mappedKeys(this)) {
            if (otherSet.contains(value)) continue;
            newRoot = newRoot.mappedDelete(this, value);
        }
        return this.createForDelete(newRoot);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants(this);
    }

    @Override
    public void forEach(@Nonnull Consumer<? super T> action) {
        this.root.forEach((T node) -> node.forEach(this.collisionSet, action::accept));
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
        this.root.forEachThrows(node -> node.forEachThrows(this.collisionSet, proc));
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.root.mappedKeys(this).iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1024;
    }

    @Override
    public boolean mappedContains(@Nonnull ArraySetNode<T> mapping, @Nonnull T key) {
        return mapping.contains(this.collisionSet, key);
    }

    @Override
    @Nonnull
    public ArraySetNode<T> mappedAssign(@Nonnull T key, T ignored) {
        assert (key == ignored);
        return new ArraySingleValueSetNode<T>(key);
    }

    @Override
    @Nonnull
    public ArraySetNode<T> mappedAssign(@Nonnull ArraySetNode<T> current, @Nonnull T key, T ignored) {
        assert (key == ignored);
        return current.insert(this.collisionSet, key);
    }

    @Override
    @Nullable
    public ArraySetNode<T> mappedDelete(@Nonnull ArraySetNode<T> current, @Nonnull T key) {
        return current.delete(this.collisionSet, key);
    }

    @Override
    public int mappedSize(@Nonnull ArraySetNode<T> mapping) {
        return mapping.size(this.collisionSet);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<T> mappedKeys(@Nonnull ArraySetNode<T> mapping) {
        return mapping.values(this.collisionSet);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<T> mappedValues(@Nonnull ArraySetNode<T> mapping) {
        return mapping.values(this.collisionSet);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<JImmutableMap.Entry<T, T>> mappedEntries(@Nonnull ArraySetNode<T> mapping) {
        return GenericIterator.transformIterable(mapping.values(this.collisionSet), k -> MapEntry.entry(k, k));
    }

    private Object writeReplace() {
        return new JImmutableHashSetProxy(this);
    }

    private JImmutableSet<T> createForUpdate(@Nonnull TrieArrayNode<ArraySetNode<T>> newRoot) {
        if (this.root == newRoot) {
            return this;
        }
        assert (newRoot.size() > 0);
        return new JImmutableHashSet<T>(newRoot, this.collisionSet);
    }

    private JImmutableSet<T> createForDelete(@Nonnull TrieArrayNode<ArraySetNode<T>> newRoot) {
        if (this.root == newRoot) {
            return this;
        }
        if (newRoot.isEmpty()) {
            return JImmutableHashSet.of();
        }
        return new JImmutableHashSet<T>(newRoot, this.collisionSet);
    }
}

