/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.common.CollisionMap;
import org.javimmutable.collections.hash.map.ArrayMapNode;
import org.javimmutable.collections.hash.map.ArraySingleValueMapNode;
import org.javimmutable.collections.iterators.GenericIterator;

@Immutable
public class ArrayMultiValueMapNode<K, V>
implements ArrayMapNode<K, V> {
    @Nonnull
    private final CollisionMap.Node node;

    public ArrayMultiValueMapNode(@Nonnull CollisionMap.Node node) {
        this.node = node;
    }

    @Override
    public int size(@Nonnull CollisionMap<K, V> collisionMap) {
        return collisionMap.size(this.node);
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key, V defaultValue) {
        return collisionMap.getValueOr(this.node, key, defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key) {
        return collisionMap.findValue(this.node, key);
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> assign(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key, V value) {
        CollisionMap.Node thisNode = this.node;
        CollisionMap.Node newNode = collisionMap.update(thisNode, key, value);
        if (newNode == thisNode) {
            return this;
        }
        return new ArrayMultiValueMapNode<K, V>(newNode);
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> update(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        CollisionMap.Node thisNode = this.node;
        CollisionMap.Node newNode = collisionMap.update(thisNode, key, generator);
        if (newNode == thisNode) {
            return this;
        }
        return new ArrayMultiValueMapNode<K, V>(newNode);
    }

    @Override
    @Nullable
    public ArrayMapNode<K, V> delete(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key) {
        CollisionMap.Node thisNode = this.node;
        CollisionMap.Node newNode = collisionMap.delete(thisNode, key);
        if (newNode == thisNode) {
            return this;
        }
        int newSize = collisionMap.size(newNode);
        switch (newSize) {
            case 0: {
                return null;
            }
            case 1: {
                return new ArraySingleValueMapNode<K, V>(collisionMap.first(newNode));
            }
        }
        return new ArrayMultiValueMapNode<K, V>(newNode);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<K> keys(@Nonnull CollisionMap<K, V> collisionMap) {
        return GenericIterator.transformIterable(collisionMap.genericIterable(this.node), JImmutableMap.Entry::getKey);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<V> values(@Nonnull CollisionMap<K, V> collisionMap) {
        return GenericIterator.transformIterable(collisionMap.genericIterable(this.node), JImmutableMap.Entry::getValue);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<JImmutableMap.Entry<K, V>> entries(@Nonnull CollisionMap<K, V> collisionMap) {
        return collisionMap.genericIterable(this.node);
    }

    @Override
    public void forEach(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull Proc2<K, V> proc) {
        collisionMap.forEach(this.node, proc);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull Proc2Throws<K, V, E> proc) throws E {
        collisionMap.forEachThrows(this.node, proc);
    }
}

