/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.common.CollisionMap;
import org.javimmutable.collections.hash.map.ArrayMapNode;
import org.javimmutable.collections.hash.map.ArrayMultiValueMapNode;
import org.javimmutable.collections.iterators.GenericIterator;

@Immutable
public class ArraySingleValueMapNode<K, V>
implements ArrayMapNode<K, V> {
    private final K key;
    private final V value;

    public ArraySingleValueMapNode(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public ArraySingleValueMapNode(JImmutableMap.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue());
    }

    @Override
    public int size(@Nonnull CollisionMap<K, V> collisionMap) {
        return 1;
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key, V defaultValue) {
        return key.equals(this.key) ? this.value : defaultValue;
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key) {
        return key.equals(this.key) ? Holders.of(this.value) : Holders.of();
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> assign(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key, V value) {
        K thisKey = this.key;
        V thisValue = this.value;
        if (!key.equals(thisKey)) {
            return new ArrayMultiValueMapNode(collisionMap.dual(thisKey, thisValue, key, value));
        }
        if (value == thisValue) {
            return this;
        }
        return new ArraySingleValueMapNode<K, V>(thisKey, value);
    }

    @Override
    @Nonnull
    public ArrayMapNode<K, V> update(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        K thisKey = this.key;
        V thisValue = this.value;
        if (!key.equals(thisKey)) {
            V value = generator.apply(Holders.of());
            return new ArrayMultiValueMapNode(collisionMap.dual(thisKey, thisValue, key, value));
        }
        V value = generator.apply(Holders.of(thisValue));
        if (value == thisValue) {
            return this;
        }
        return new ArraySingleValueMapNode<K, V>(thisKey, value);
    }

    @Override
    @Nullable
    public ArrayMapNode<K, V> delete(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull K key) {
        return key.equals(this.key) ? null : this;
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<K> keys(@Nonnull CollisionMap<K, V> collisionMap) {
        return GenericIterator.singleValueIterable(this.key);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<V> values(@Nonnull CollisionMap<K, V> collisionMap) {
        return GenericIterator.singleValueIterable(this.value);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<JImmutableMap.Entry<K, V>> entries(@Nonnull CollisionMap<K, V> collisionMap) {
        return GenericIterator.singleValueIterable(MapEntry.entry(this.key, this.value));
    }

    @Override
    public void forEach(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull Proc2<K, V> proc) {
        proc.apply(this.key, this.value);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionMap<K, V> collisionMap, @Nonnull Proc2Throws<K, V, E> proc) throws E {
        proc.apply(this.key, this.value);
    }
}

