/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Proc1;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.hash.set.ArraySetNode;
import org.javimmutable.collections.hash.set.ArraySingleValueSetNode;
import org.javimmutable.collections.iterators.GenericIterator;

@Immutable
public class ArrayMultiValueSetNode<T>
implements ArraySetNode<T> {
    private final CollisionSet.Node node;

    public ArrayMultiValueSetNode(@Nonnull CollisionSet.Node node) {
        this.node = node;
    }

    @Override
    public int size(@Nonnull CollisionSet<T> collisionSet) {
        return collisionSet.size(this.node);
    }

    @Override
    public boolean contains(@Nonnull CollisionSet<T> collisionSet, @Nonnull T value) {
        return collisionSet.contains(this.node, value);
    }

    @Override
    @Nonnull
    public ArraySetNode<T> insert(@Nonnull CollisionSet<T> collisionSet, @Nonnull T value) {
        CollisionSet.Node oldNode = this.node;
        CollisionSet.Node newNode = collisionSet.insert(oldNode, value);
        if (newNode == oldNode) {
            return this;
        }
        return new ArrayMultiValueSetNode<T>(newNode);
    }

    @Override
    @Nullable
    public ArraySetNode<T> delete(@Nonnull CollisionSet<T> collisionSet, @Nonnull T value) {
        CollisionSet.Node oldNode = this.node;
        CollisionSet.Node newNode = collisionSet.delete(oldNode, value);
        if (newNode == oldNode) {
            return this;
        }
        int newSize = collisionSet.size(newNode);
        switch (newSize) {
            case 0: {
                return null;
            }
            case 1: {
                return new ArraySingleValueSetNode<T>(collisionSet.first(newNode));
            }
        }
        return new ArrayMultiValueSetNode<T>(newNode);
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<T> values(@Nonnull CollisionSet<T> collisionSet) {
        return collisionSet.genericIterable(this.node);
    }

    @Override
    public void forEach(@Nonnull CollisionSet<T> collisionSet, @Nonnull Proc1<T> proc) {
        collisionSet.forEach(this.node, proc);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionSet<T> collisionSet, @Nonnull Proc1Throws<T, E> proc) throws E {
        collisionSet.forEachThrows(this.node, proc);
    }
}

