/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.hash.set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Proc1;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.hash.set.ArrayMultiValueSetNode;
import org.javimmutable.collections.hash.set.ArraySetNode;
import org.javimmutable.collections.iterators.GenericIterator;

@Immutable
public class ArraySingleValueSetNode<T>
implements ArraySetNode<T> {
    private final T value;

    public ArraySingleValueSetNode(T value) {
        this.value = value;
    }

    @Override
    public int size(@Nonnull CollisionSet<T> collisionSet) {
        return 1;
    }

    @Override
    public boolean contains(@Nonnull CollisionSet<T> collisionSet, @Nonnull T value) {
        return this.value.equals(value);
    }

    @Override
    @Nonnull
    public ArraySetNode<T> insert(@Nonnull CollisionSet<T> collisionSet, @Nonnull T value) {
        T thisValue = this.value;
        if (thisValue.equals(value)) {
            return this;
        }
        return new ArrayMultiValueSetNode(collisionSet.dual(thisValue, value));
    }

    @Override
    @Nullable
    public ArraySetNode<T> delete(@Nonnull CollisionSet<T> collisionSet, @Nonnull T value) {
        return value.equals(this.value) ? null : this;
    }

    @Override
    @Nonnull
    public GenericIterator.Iterable<T> values(@Nonnull CollisionSet<T> collisionSet) {
        return GenericIterator.singleValueIterable(this.value);
    }

    @Override
    public void forEach(@Nonnull CollisionSet<T> collisionSet, @Nonnull Proc1<T> proc) {
        proc.apply(this.value);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionSet<T> collisionSet, @Nonnull Proc1Throws<T, E> proc) throws E {
        proc.apply(this.value);
    }
}

