/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.indexed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Indexed;

@Immutable
public class IndexedList<T>
implements Indexed<T>,
Iterable<T> {
    private final List<? extends T> values;

    private IndexedList(List<? extends T> values) {
        this.values = values;
    }

    public static <T> IndexedList<T> copied(List<? extends T> values) {
        return new IndexedList<T>(new ArrayList<T>(values));
    }

    public static <T> IndexedList<T> retained(List<? extends T> values) {
        return new IndexedList<T>(values);
    }

    @Override
    public T get(int index) {
        return this.values.get(index);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        final Iterator<? extends T> i = this.values.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                return i.next();
            }
        };
    }
}

