/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.inorder;

import java.io.Serializable;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.GenericCollector;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Temp;
import org.javimmutable.collections.array.TrieLongArrayNode;
import org.javimmutable.collections.common.AbstractJImmutableMap;
import org.javimmutable.collections.hash.JImmutableHashMap;
import org.javimmutable.collections.iterators.TransformStreamable;
import org.javimmutable.collections.serialization.JImmutableInsertOrderMapProxy;

@Immutable
public class JImmutableInsertOrderMap<K, V>
extends AbstractJImmutableMap<K, V>
implements Serializable {
    public static final JImmutableInsertOrderMap EMPTY = new JImmutableInsertOrderMap(TrieLongArrayNode.empty(), JImmutableHashMap.of(), Long.MIN_VALUE);
    private static final long serialVersionUID = -121805L;
    private static final int SPLITERATOR_CHARACTERISTICS = 1040;
    private final TrieLongArrayNode<K> keys;
    private final JImmutableMap<K, Node<V>> values;
    private final long nextToken;

    private JImmutableInsertOrderMap(@Nonnull TrieLongArrayNode<K> keys, @Nonnull JImmutableMap<K, Node<V>> values, long nextToken) {
        assert (keys.size() == values.size());
        this.keys = keys;
        this.values = values;
        this.nextToken = nextToken;
    }

    public static <K, V> JImmutableInsertOrderMap<K, V> of() {
        return EMPTY;
    }

    @Nonnull
    public static <K, V> JImmutableMap.Builder<K, V> builder() {
        return new JImmutableMap.Builder<K, V>(){
            private JImmutableInsertOrderMap<K, V> map = JImmutableInsertOrderMap.of();

            @Override
            @Nonnull
            public synchronized JImmutableMap<K, V> build() {
                return this.map;
            }

            @Override
            @Nonnull
            public synchronized JImmutableMap.Builder<K, V> clear() {
                this.map = JImmutableInsertOrderMap.of();
                return this;
            }

            @Override
            @Nonnull
            public synchronized JImmutableMap.Builder<K, V> add(@Nonnull K key, V value) {
                this.map = this.map.assign(key, value);
                return this;
            }

            @Override
            public synchronized int size() {
                return this.map.size();
            }
        };
    }

    @Override
    @Nonnull
    public JImmutableMap.Builder<K, V> mapBuilder() {
        return JImmutableInsertOrderMap.builder();
    }

    @Nonnull
    public static <K, V> Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> createMapCollector() {
        JImmutableInsertOrderMap<K, V> empty = JImmutableInsertOrderMap.of();
        return GenericCollector.ordered(empty, empty, a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> (JImmutableMap)a.insertAll(b));
    }

    @Override
    @Nonnull
    public Collector<JImmutableMap.Entry<K, V>, ?, JImmutableMap<K, V>> mapCollector() {
        return GenericCollector.ordered(this, JImmutableInsertOrderMap.of(), a -> a.isEmpty(), (a, v) -> a.insert(v), (a, b) -> (JImmutableMap)a.insertAll(b));
    }

    @Override
    public V getValueOr(K key, V defaultValue) {
        Node current = (Node)this.values.get(key);
        return (V)(current != null ? current.value : defaultValue);
    }

    @Override
    @Nonnull
    public Holder<V> find(@Nonnull K key) {
        Node current = (Node)this.values.get(key);
        return current != null ? Holders.of(current.value) : Holders.of();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull K key) {
        Node current = (Node)this.values.get(key);
        return current != null ? Holders.of(MapEntry.entry(key, current.value)) : Holders.of();
    }

    @Override
    @Nonnull
    public JImmutableInsertOrderMap<K, V> assign(@Nonnull K key, V value) {
        Temp.Var1<Boolean> inserted = new Temp.Var1<Boolean>(false);
        JImmutableMap<K, Node> newValues = this.values.update(key, hv -> {
            if (hv.isEmpty()) {
                inserted.x = true;
                return new Node(this.nextToken, value);
            }
            Node node = (Node)hv.getValue();
            return node.withValue(value);
        });
        if (((Boolean)inserted.x).booleanValue()) {
            TrieLongArrayNode<K> newKeys = this.keys.assign(this.nextToken, key);
            return new JImmutableInsertOrderMap<K, V>(newKeys, newValues, this.nextToken + 1L);
        }
        if (newValues != this.values) {
            return new JImmutableInsertOrderMap<K, V>(this.keys, newValues, this.nextToken);
        }
        return this;
    }

    @Override
    @Nonnull
    public JImmutableInsertOrderMap<K, V> delete(@Nonnull K key) {
        Node current = (Node)this.values.get(key);
        if (current == null) {
            return this;
        }
        if (this.values.size() == 1) {
            return JImmutableInsertOrderMap.of();
        }
        return new JImmutableInsertOrderMap<K, V>(this.keys.delete(current.token), this.values.delete(key), this.nextToken);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    @Nonnull
    public JImmutableInsertOrderMap<K, V> deleteAll() {
        return JImmutableInsertOrderMap.of();
    }

    @Override
    @Nonnull
    public SplitableIterator<JImmutableMap.Entry<K, V>> iterator() {
        return TransformStreamable.of(this.keys(), k -> MapEntry.entry(k, this.valueForKey(k))).iterator();
    }

    @Override
    @Nonnull
    public IterableStreamable<K> keys() {
        return this.keys.values().streamable(1040);
    }

    @Override
    @Nonnull
    public IterableStreamable<V> values() {
        return TransformStreamable.of(this.keys(), this::valueForKey);
    }

    private V valueForKey(K key) {
        Node node = (Node)this.values.get(key);
        assert (node != null);
        return (V)node.value;
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    @Override
    public void checkInvariants() {
        if (this.keys.size() != this.values.size()) {
            throw new IllegalStateException(String.format("size mismatch: sorted=%s hashed=%s", this.keys.size(), this.values.size()));
        }
        for (JImmutableMap.Entry entry : this.keys.entries()) {
            Node node = (Node)this.values.get(entry.getValue());
            if (node == null) {
                throw new IllegalStateException(String.format("node missing: token=%s key=%s", entry.getKey(), entry.getValue()));
            }
            if (((Long)entry.getKey()).equals(node.token)) continue;
            throw new IllegalStateException(String.format("node mismatch: sorted=%s hashed=%s", entry, node));
        }
    }

    private Object writeReplace() {
        return new JImmutableInsertOrderMapProxy(this);
    }

    @Immutable
    private static class Node<V> {
        private final long token;
        private final V value;

        private Node(long token, V value) {
            this.token = token;
            this.value = value;
        }

        private Node<V> withValue(V value) {
            return value == this.value ? this : new Node<V>(this.token, value);
        }
    }
}

