/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.javimmutable.collections.SplitIterator;
import org.javimmutable.collections.SplitableIterator;

public abstract class AbstractSplitableIterator<T>
implements SplitableIterator<T> {
    @Override
    @Nonnull
    public Spliterator<T> spliterator(int characteristics) {
        return new SpliteratorImpl(characteristics, this);
    }

    private static class SpliteratorImpl<T>
    implements Spliterator<T> {
        private final int characteristics;
        @Nonnull
        private SplitableIterator<T> iterator;

        private SpliteratorImpl(int characteristics, @Nonnull SplitableIterator<T> iterator) {
            this.characteristics = characteristics;
            this.iterator = iterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.iterator.hasNext()) {
                action.accept(this.iterator.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            if (this.iterator.isSplitAllowed()) {
                SplitIterator<T> split = this.iterator.splitIterator();
                this.iterator = split.getRight();
                return new SpliteratorImpl<T>(this.characteristics, split.getLeft());
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }
    }
}

