/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.IterableStreamable;
import org.javimmutable.collections.SplitIterator;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.iterators.AbstractSplitableIterator;

@ThreadSafe
public class GenericIterator<T>
extends AbstractSplitableIterator<T> {
    static final int MIN_SIZE_FOR_SPLIT = 32;
    private final Iterable<T> root;
    private final int limit;
    private int offset;
    private boolean uninitialized;
    private State<T> state;

    public GenericIterator(@Nonnull Iterable<T> root, int offset, int limit) {
        assert (offset <= limit);
        this.root = root;
        this.limit = limit;
        this.offset = offset;
        this.uninitialized = true;
    }

    @Override
    public synchronized boolean hasNext() {
        this.advanceStateToStartingPositionIfNecessary();
        return this.stateHasValue();
    }

    @Override
    public synchronized T next() {
        this.advanceStateToStartingPositionIfNecessary();
        if (!this.stateHasValue()) {
            throw new NoSuchElementException();
        }
        T answer = this.state.value();
        ++this.offset;
        this.state = this.offset < this.limit ? this.state.advance() : null;
        assert (this.offset <= this.limit);
        return answer;
    }

    @Override
    public synchronized boolean isSplitAllowed() {
        return this.limit - this.offset >= 32;
    }

    @Override
    @Nonnull
    public synchronized SplitIterator<T> splitIterator() {
        int splitIndex = this.offset + (this.limit - this.offset) / 2;
        return new SplitIterator<T>(new GenericIterator<T>(this.root, this.offset, splitIndex), new GenericIterator<T>(this.root, splitIndex, this.limit));
    }

    private void advanceStateToStartingPositionIfNecessary() {
        if (this.uninitialized) {
            this.state = this.root.iterateOverRange(null, this.offset, this.limit);
            this.uninitialized = false;
        }
        while (this.state != null && !this.state.hasValue()) {
            this.state = this.state.advance();
        }
    }

    private boolean stateHasValue() {
        return this.state != null && this.state.hasValue();
    }

    public static <T> State<T> singleValueState(State<T> parent, T value) {
        return new SingleValueState(parent, value);
    }

    public static <T> Iterable<T> singleValueIterable(final T value) {
        return new Iterable<T>(){

            @Override
            public State<T> iterateOverRange(@Nullable State<T> parent, int offset, int limit) {
                assert (offset >= 0 && offset <= limit && limit <= 1);
                if (offset == limit) {
                    return parent;
                }
                return new SingleValueState(parent, value);
            }

            @Override
            public int iterableSize() {
                return 1;
            }
        };
    }

    public static <T> State<T> multiValueState(@Nullable State<T> parent, @Nonnull Indexed<T> values, int offset, int limit) {
        assert (offset >= 0 && offset <= limit && limit <= values.size());
        return new MultiValueState(parent, values, offset, limit);
    }

    public static <T> State<T> multiIterableState(@Nullable State<T> parent, @Nonnull Indexed<? extends Iterable<T>> children, int offset, int limit) {
        assert (0 <= offset && offset <= limit);
        if (offset == limit) {
            return parent;
        }
        return new MultiIterableState(parent, children, offset, limit);
    }

    public static <A, B> State<B> transformState(@Nullable State<B> parent, @Nullable State<A> source, @Nonnull Func1<A, B> transforminator) {
        if (source == null) {
            return parent;
        }
        return new TransformState(parent, source, transforminator);
    }

    public static <A, B> Iterable<B> transformIterable(final @Nonnull Iterable<A> source, final @Nonnull Func1<A, B> transforminator) {
        return new Iterable<B>(){

            @Override
            @Nullable
            public State<B> iterateOverRange(@Nullable State<B> parent, int offset, int limit) {
                return GenericIterator.transformState(parent, source.iterateOverRange(null, offset, limit), transforminator);
            }

            @Override
            public int iterableSize() {
                return source.iterableSize();
            }
        };
    }

    private static class TransformState<A, B>
    implements State<B> {
        private final Func1<A, B> transforminator;
        private final State<B> parent;
        private State<A> source;

        private TransformState(@Nullable State<B> parent, @Nonnull State<A> source, @Nonnull Func1<A, B> transforminator) {
            this.transforminator = transforminator;
            this.parent = parent;
            this.source = source;
        }

        @Override
        public boolean hasValue() {
            return this.source.hasValue();
        }

        @Override
        public B value() {
            return this.transforminator.apply(this.source.value());
        }

        @Override
        @Nullable
        public State<B> advance() {
            this.source = this.source.advance();
            if (this.source == null) {
                return this.parent;
            }
            return this;
        }
    }

    private static class MultiIterableState<T>
    implements State<T> {
        private final State<T> parent;
        private final Indexed<? extends Iterable<T>> collections;
        private int offset;
        private int limit;
        private int index;

        private MultiIterableState(@Nullable State<T> parent, @Nonnull Indexed<? extends Iterable<T>> collections, int offset, int limit) {
            this.parent = parent;
            this.collections = collections;
            this.limit = limit;
            this.offset = offset;
            this.index = 0;
        }

        @Override
        public State<T> advance() {
            Iterable<T> collection = this.collections.get(this.index);
            int size = collection.iterableSize();
            if (this.offset >= size) {
                ++this.index;
                this.offset -= size;
                this.limit -= size;
                return this;
            }
            if (this.limit <= size) {
                return collection.iterateOverRange(this.parent, this.offset, this.limit);
            }
            State<T> answer = collection.iterateOverRange(this, this.offset, size);
            ++this.index;
            this.offset = 0;
            this.limit -= size;
            return answer;
        }
    }

    private static class MultiValueState<T>
    implements State<T> {
        private final State<T> parent;
        private final Indexed<T> values;
        private final int limit;
        private int offset;

        private MultiValueState(@Nullable State<T> parent, @Nonnull Indexed<T> values, int offset, int limit) {
            this.parent = parent;
            this.values = values;
            this.offset = offset;
            this.limit = limit;
        }

        @Override
        public boolean hasValue() {
            return this.offset < this.limit;
        }

        @Override
        public T value() {
            return this.values.get(this.offset);
        }

        @Override
        @Nullable
        public State<T> advance() {
            ++this.offset;
            if (this.offset < this.limit) {
                return this;
            }
            return this.parent;
        }
    }

    private static class SingleValueState<T>
    implements State<T> {
        private final State<T> parent;
        private final T value;
        private boolean available;

        private SingleValueState(@Nullable State<T> parent, T value) {
            this.parent = parent;
            this.value = value;
            this.available = true;
        }

        @Override
        public boolean hasValue() {
            return this.available;
        }

        @Override
        public T value() {
            assert (this.available);
            this.available = false;
            return this.value;
        }

        @Override
        public State<T> advance() {
            assert (!this.available);
            return this.parent;
        }
    }

    public static interface State<T> {
        default public boolean hasValue() {
            return false;
        }

        default public T value() {
            throw new NoSuchElementException();
        }

        public State<T> advance();
    }

    public static interface Iterable<T>
    extends SplitableIterable<T> {
        @Nullable
        public State<T> iterateOverRange(@Nullable State<T> var1, int var2, int var3);

        public int iterableSize();

        @Override
        @Nonnull
        default public SplitableIterator<T> iterator() {
            return new GenericIterator(this, 0, this.iterableSize());
        }

        @Nonnull
        default public IterableStreamable<T> streamable(final int characteristics) {
            return new IterableStreamable<T>(){

                @Override
                @Nonnull
                public SplitableIterator<T> iterator() {
                    return this.iterator();
                }

                @Override
                public int getSpliteratorCharacteristics() {
                    return characteristics;
                }
            };
        }
    }
}

