/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.SplitIterator;
import org.javimmutable.collections.SplitableIterable;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.iterators.AbstractSplitableIterator;
import org.javimmutable.collections.iterators.IndexedIterator;
import org.javimmutable.collections.iterators.TransformIterator;

public class LazyMultiIterator<T>
extends AbstractSplitableIterator<T> {
    @Nonnull
    private final SplitableIterator<SplitableIterable<T>> source;
    @Nullable
    private SplitableIterator<T> iterator;
    private boolean advanced;
    private boolean hasNext;
    private T nextValue;

    private LazyMultiIterator(@Nonnull SplitableIterator<SplitableIterable<T>> source, @Nullable SplitableIterator<T> iterator, boolean advanced, boolean hasNext, T nextValue) {
        this.source = source;
        this.iterator = iterator;
        this.advanced = advanced;
        this.hasNext = hasNext;
        this.nextValue = nextValue;
    }

    @Nonnull
    public static <T> LazyMultiIterator<T> iterator(@Nonnull Indexed<SplitableIterable<T>> source) {
        return LazyMultiIterator.iterator(IndexedIterator.iterator(source));
    }

    @Nonnull
    public static <T> LazyMultiIterator<T> iterator(@Nonnull SplitableIterator<SplitableIterable<T>> source) {
        return new LazyMultiIterator<Object>(source, null, false, false, null);
    }

    public static <S, T> LazyMultiIterator<T> transformed(SplitableIterator<S> source, Function<S, SplitableIterable<T>> transforminator) {
        return LazyMultiIterator.iterator(TransformIterator.of(source, transforminator));
    }

    public static <S, T> LazyMultiIterator<T> transformed(Indexed<S> source, Function<S, SplitableIterable<T>> transforminator) {
        return LazyMultiIterator.iterator(TransformIterator.of(IndexedIterator.iterator(source), transforminator));
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.hasNext;
    }

    @Override
    public T next() {
        this.advance();
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.advanced = false;
        return this.nextValue;
    }

    @Override
    public boolean isSplitAllowed() {
        return this.source.isSplitAllowed();
    }

    @Override
    @Nonnull
    public SplitIterator<T> splitIterator() {
        SplitIterator<SplitableIterable<T>> split = this.source.splitIterator();
        return new SplitIterator<Object>(new LazyMultiIterator<T>(split.getLeft(), this.iterator, this.advanced, this.hasNext, this.nextValue), new LazyMultiIterator<Object>(split.getRight(), null, false, false, null));
    }

    private void advance() {
        if (!this.advanced) {
            this.advanceImpl();
            this.advanced = true;
        }
    }

    private void advanceImpl() {
        if (this.iterator != null && this.iterator.hasNext()) {
            this.hasNext = true;
            this.nextValue = this.iterator.next();
            return;
        }
        assert (this.iterator == null || !this.iterator.hasNext());
        while (this.source.hasNext()) {
            SplitableIterable nextIterable = (SplitableIterable)this.source.next();
            Iterator nextIterator = nextIterable.iterator();
            if (!nextIterator.hasNext()) continue;
            this.iterator = nextIterator;
            this.hasNext = true;
            this.nextValue = this.iterator.next();
            return;
        }
        this.hasNext = false;
    }
}

