/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.javimmutable.collections.Sequence;
import org.javimmutable.collections.iterators.AbstractSplitableIterator;

public class SequenceIterator<T>
extends AbstractSplitableIterator<T> {
    private final Sequence<T> sequence;
    private Sequence<T> current;

    private SequenceIterator(@Nonnull Sequence<T> sequence) {
        this.sequence = sequence;
    }

    public static <T> SequenceIterator<T> iterator(@Nonnull Sequence<T> sequence) {
        return new SequenceIterator<T>(sequence);
    }

    @Override
    public boolean hasNext() {
        return !this.nextImpl().isEmpty();
    }

    @Override
    public T next() {
        this.current = this.nextImpl();
        if (this.current.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.current.getHead();
    }

    @Nonnull
    private Sequence<T> nextImpl() {
        if (this.current == null) {
            return this.sequence;
        }
        if (this.current.isEmpty()) {
            return this.current;
        }
        return this.current.getTail();
    }
}

