/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.iterators;

import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class SimpleTransformIterator<S, T>
implements Iterator<T> {
    private final Iterator<S> source;
    private final Function<S, T> transforminator;

    public SimpleTransformIterator(@Nonnull Iterator<S> source, @Nonnull Function<S, T> transforminator) {
        this.source = source;
        this.transforminator = transforminator;
    }

    public static <S, T> Iterator<T> of(@Nonnull Iterator<S> source, @Nonnull Function<S, T> transforminator) {
        return new SimpleTransformIterator<S, T>(source, transforminator);
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public T next() {
        return this.transforminator.apply(this.source.next());
    }
}

