/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.indexed.IndexedHelper;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.MultiValueNode;

@Immutable
class BranchNode<T>
extends AbstractNode<T> {
    private final AbstractNode<T> left;
    private final AbstractNode<T> right;
    private final int size;
    private final int depth;

    BranchNode(@Nonnull AbstractNode<T> left, @Nonnull AbstractNode<T> right) {
        this(left, right, left.size() + right.size());
    }

    BranchNode(@Nonnull AbstractNode<T> left, @Nonnull AbstractNode<T> right, int size) {
        assert (!left.isEmpty());
        assert (!right.isEmpty());
        this.left = left;
        this.right = right;
        this.size = size;
        this.depth = 1 + Math.max(left.depth(), right.depth());
        assert (size > 128);
    }

    @Nonnull
    private static <T> AbstractNode<T> join(@Nonnull AbstractNode<T> left, @Nonnull AbstractNode<T> right) {
        int size = left.size() + right.size();
        if (size <= 128) {
            return new MultiValueNode<T>(left, right, size);
        }
        return new BranchNode<T>(left, right, size);
    }

    @Nonnull
    static <T> AbstractNode<T> balance(@Nonnull AbstractNode<T> left, @Nonnull AbstractNode<T> right) {
        int diff = left.depth() - right.depth();
        if (diff > 1) {
            return BranchNode.rotateRight(left, right);
        }
        if (diff < -1) {
            return BranchNode.rotateLeft(right, left);
        }
        return BranchNode.join(left, right);
    }

    @Override
    boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    int size() {
        return this.size;
    }

    @Override
    int depth() {
        return this.depth;
    }

    @Override
    T get(int index) {
        int leftSize = this.left.size();
        if (index < leftSize) {
            return this.left.get(index);
        }
        return this.right.get(index - leftSize);
    }

    @Override
    @Nonnull
    AbstractNode<T> append(T value) {
        return BranchNode.balance(this.left, this.right.append(value));
    }

    @Override
    @Nonnull
    AbstractNode<T> append(@Nonnull AbstractNode<T> node) {
        if (node.isEmpty()) {
            return this;
        }
        int diff = this.depth - node.depth();
        if (diff < 0) {
            return node.prepend(this);
        }
        if (diff <= 1) {
            return new BranchNode<T>(this, node);
        }
        return BranchNode.balance(this.left, this.right.append(node));
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(T value) {
        return BranchNode.balance(this.left.prepend(value), this.right);
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(@Nonnull AbstractNode<T> node) {
        if (node.isEmpty()) {
            return this;
        }
        int diff = this.depth - node.depth();
        if (diff < 0) {
            return node.append(this);
        }
        if (diff <= 1) {
            return new BranchNode<T>(node, this);
        }
        return BranchNode.balance(this.left.prepend(node), this.right);
    }

    @Override
    @Nonnull
    AbstractNode<T> assign(int index, T value) {
        int leftSize = this.left.size();
        if (index < leftSize) {
            return new BranchNode<T>(this.left.assign(index, value), this.right);
        }
        return new BranchNode<T>(this.left, this.right.assign(index - leftSize, value));
    }

    @Override
    @Nonnull
    AbstractNode<T> insert(int index, T value) {
        int leftSize = this.left.size();
        if (index < leftSize) {
            return BranchNode.balance(this.left.insert(index, value), this.right);
        }
        if (index == leftSize && leftSize <= this.right.size()) {
            return BranchNode.balance(this.left.insert(index, value), this.right);
        }
        return BranchNode.balance(this.left, this.right.insert(index - leftSize, value));
    }

    @Override
    @Nonnull
    AbstractNode<T> delete(int index) {
        AbstractNode<T> newRight;
        AbstractNode<T> newLeft;
        int leftSize = this.left.size();
        if (index < leftSize) {
            newLeft = this.left.delete(index);
            newRight = this.right;
            if (newLeft.isEmpty()) {
                return this.right;
            }
        } else {
            newLeft = this.left;
            newRight = this.right.delete(index - leftSize);
            if (newRight.isEmpty()) {
                return this.left;
            }
        }
        return BranchNode.balance(newLeft, newRight);
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteFirst() {
        AbstractNode<T> newLeft = this.left.deleteFirst();
        if (newLeft.isEmpty()) {
            return this.right;
        }
        return BranchNode.balance(newLeft, this.right);
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteLast() {
        AbstractNode<T> newRight = this.right.deleteLast();
        if (newRight.isEmpty()) {
            return this.left;
        }
        return BranchNode.balance(this.left, newRight);
    }

    @Override
    void copyTo(T[] array, int offset) {
        this.left.copyTo(array, offset);
        this.right.copyTo(array, offset + this.left.size());
    }

    @Override
    @Nonnull
    AbstractNode<T> prefix(int limit) {
        if (limit == this.size) {
            return this;
        }
        if (limit == 0) {
            return EmptyNode.instance();
        }
        int leftSize = this.left.size();
        if (limit <= leftSize) {
            return this.left.prefix(limit);
        }
        return this.left.append(this.right.prefix(limit - leftSize));
    }

    @Override
    @Nonnull
    AbstractNode<T> suffix(int offset) {
        if (offset == 0) {
            return this;
        }
        if (offset == this.size) {
            return EmptyNode.instance();
        }
        int leftSize = this.left.size();
        if (offset < leftSize) {
            return this.left.suffix(offset).append(this.right);
        }
        return this.right.suffix(offset - leftSize);
    }

    @Override
    @Nonnull
    AbstractNode<T> reverse() {
        return new BranchNode<T>(this.right.reverse(), this.left.reverse(), this.size);
    }

    @Override
    @Nonnull
    AbstractNode<T> left() {
        return this.left;
    }

    @Override
    @Nonnull
    AbstractNode<T> right() {
        return this.right;
    }

    @Nonnull
    private static <T> AbstractNode<T> rotateRight(@Nonnull AbstractNode<T> node, @Nonnull AbstractNode<T> parentRight) {
        AbstractNode<T> left = node.left();
        AbstractNode<T> right = node.right();
        if (left.depth() >= right.depth()) {
            return BranchNode.join(left, BranchNode.join(right, parentRight));
        }
        return BranchNode.join(BranchNode.join(left, right.left()), BranchNode.join(right.right(), parentRight));
    }

    @Nonnull
    private static <T> AbstractNode<T> rotateLeft(@Nonnull AbstractNode<T> node, @Nonnull AbstractNode<T> parentLeft) {
        AbstractNode<T> left = node.left();
        AbstractNode<T> right = node.right();
        if (left.depth() > right.depth()) {
            return BranchNode.join(BranchNode.join(parentLeft, left.left()), BranchNode.join(left.right(), right));
        }
        return BranchNode.join(BranchNode.join(parentLeft, left), right);
    }

    @Override
    public void checkInvariants() {
        if (this.depth != Math.max(this.left.depth(), this.right.depth()) + 1) {
            throw new RuntimeException(String.format("incorrect depth: depth=%d leftDepth=%d rightDepth=%d", this.depth, this.left.depth(), this.right.depth()));
        }
        if (Math.abs(this.left.depth() - this.right.depth()) > 1) {
            throw new RuntimeException(String.format("invalid child depths: leftDepth=%d rightDepth=%d", this.left.depth(), this.right.depth()));
        }
        if (this.size != this.left.size() + this.right.size()) {
            throw new RuntimeException(String.format("incorrect size: size=%d leftSize=%d rightSize=%d", this.size, this.left.size(), this.right.size()));
        }
        if (this.size <= 128) {
            throw new RuntimeException(String.format("invalid size: size=%d leftSize=%d rightSize=%d", this.size, this.left.size(), this.right.size()));
        }
        if (this.left.isEmpty() || this.right.isEmpty()) {
            throw new RuntimeException(String.format("branch node has an empty branch: leftSize=%d rightSize=%d", this.left.size(), this.right.size()));
        }
        this.left.checkInvariants();
        this.right.checkInvariants();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchNode that = (BranchNode)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.depth != that.depth) {
            return false;
        }
        if (!this.left.equals(that.left)) {
            return false;
        }
        return this.right.equals(that.right);
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.depth;
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", BranchNode.class.getSimpleName() + "[", "]").add("left=" + this.left).add("right=" + this.right).add("size=" + this.size).add("depth=" + this.depth).toString();
    }

    @Override
    @Nullable
    public GenericIterator.State<T> iterateOverRange(@Nullable GenericIterator.State<T> parent, int offset, int limit) {
        assert (offset >= 0 && limit <= this.size && offset <= limit);
        return GenericIterator.multiIterableState(parent, IndexedHelper.indexed(this.left, this.right), offset, limit);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.left.forEach(action);
        this.right.forEach(action);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
        this.left.forEachThrows(proc);
        this.right.forEachThrows(proc);
    }

    @Override
    public <V> V reduce(V sum, Func2<V, T, V> accumulator) {
        sum = this.left.reduce(sum, accumulator);
        sum = this.right.reduce(sum, accumulator);
        return sum;
    }

    @Override
    public <V, E extends Exception> V reduceThrows(V sum, Sum1Throws<T, V, E> accumulator) throws E {
        sum = this.left.reduceThrows(sum, accumulator);
        sum = this.right.reduceThrows(sum, accumulator);
        return sum;
    }
}

