/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.common.ToStringHelper;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.OneValueNode;

@Immutable
class EmptyNode<T>
extends AbstractNode<T> {
    private static EmptyNode INSTANCE = new EmptyNode();

    private EmptyNode() {
    }

    static <T> EmptyNode<T> instance() {
        return INSTANCE;
    }

    @Override
    boolean isEmpty() {
        return true;
    }

    @Override
    int size() {
        return 0;
    }

    @Override
    int depth() {
        return 0;
    }

    @Override
    T get(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> append(T value) {
        return new OneValueNode<T>(value);
    }

    @Override
    @Nonnull
    AbstractNode<T> append(@Nonnull AbstractNode<T> node) {
        return node;
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(T value) {
        return new OneValueNode<T>(value);
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(@Nonnull AbstractNode<T> node) {
        return node;
    }

    @Override
    @Nonnull
    AbstractNode<T> assign(int index, T value) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> insert(int index, T value) {
        if (index == 0) {
            return new OneValueNode<T>(value);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> delete(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteFirst() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteLast() {
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> prefix(int limit) {
        if (limit == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    void copyTo(T[] array, int offset) {
    }

    @Override
    @Nonnull
    AbstractNode<T> suffix(int offset) {
        if (offset == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @Nonnull
    AbstractNode<T> reverse() {
        return this;
    }

    @Override
    @Nullable
    public GenericIterator.State<T> iterateOverRange(@Nullable GenericIterator.State<T> parent, int offset, int limit) {
        assert (offset == 0 && limit == 0);
        return parent;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
    }

    @Override
    public <V> V reduce(V initialValue, Func2<V, T, V> accumulator) {
        return initialValue;
    }

    @Override
    public <V, E extends Exception> V reduceThrows(V initialValue, Sum1Throws<T, V, E> accumulator) throws E {
        return initialValue;
    }

    @Override
    public void checkInvariants() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this.forEach(value -> ToStringHelper.addToString(sb, 1, value));
        sb.append("]");
        return sb.toString();
    }
}

