/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Indexed;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.SplitableIterator;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.common.ListAdaptor;
import org.javimmutable.collections.common.MutableDelta;
import org.javimmutable.collections.indexed.IndexedList;
import org.javimmutable.collections.iterators.IteratorHelper;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.TreeBuilder;
import org.javimmutable.collections.serialization.JImmutableListProxy;

@Immutable
public class JImmutableTreeList<T>
implements JImmutableList<T>,
Serializable {
    private static final JImmutableTreeList EMPTY = new JImmutableTreeList(EmptyNode.instance());
    private static final long serialVersionUID = -121805L;
    private final AbstractNode<T> root;

    private JImmutableTreeList(@Nonnull AbstractNode<T> root) {
        this.root = root;
    }

    @Nonnull
    public static <T> JImmutableTreeList<T> of() {
        return EMPTY;
    }

    @Nonnull
    public static <T> JImmutableTreeList<T> of(@Nonnull Indexed<? extends T> values) {
        return JImmutableTreeList.create(TreeBuilder.nodeFromIndexed(values, 0, values.size()));
    }

    @Nonnull
    public static <T> JImmutableTreeList<T> of(@Nonnull Indexed<? extends T> values, int offset, int limit) {
        return JImmutableTreeList.create(TreeBuilder.nodeFromIndexed(values, offset, limit));
    }

    @Nonnull
    public static <T> JImmutableTreeList<T> of(@Nonnull Iterator<? extends T> values) {
        return JImmutableTreeList.create(TreeBuilder.nodeFromIterator(values));
    }

    @Nonnull
    public static <T> ListBuilder<T> listBuilder() {
        return new ListBuilder();
    }

    @Nonnull
    public static <T> Collector<T, ?, JImmutableList<T>> createListCollector() {
        return Collector.of(() -> new ListBuilder(), (b, v) -> b.add(v), (b1, b2) -> b1.combineWith(b2), b -> b.build(), new Collector.Characteristics[0]);
    }

    @Nonnull
    static <T> JImmutableTreeList<T> create(@Nonnull AbstractNode<T> root) {
        if (root.isEmpty()) {
            return JImmutableTreeList.of();
        }
        return new JImmutableTreeList<T>(root);
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> assign(int index, @Nullable T value) {
        return new JImmutableTreeList<T>(this.root.assign(index, value));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insert(@Nullable T value) {
        return new JImmutableTreeList<T>(this.root.append(value));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insert(int index, @Nullable T value) {
        return new JImmutableTreeList<T>(this.root.insert(index, value));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertFirst(@Nullable T value) {
        return new JImmutableTreeList<T>(this.root.prepend(value));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertLast(@Nullable T value) {
        return new JImmutableTreeList<T>(this.root.append(value));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAll(@Nonnull Iterable<? extends T> values) {
        return this.insertAllLast(this.nodeFromIterable(values));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAll(@Nonnull Iterator<? extends T> values) {
        return this.insertAllLast(TreeBuilder.nodeFromIterator(values));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAll(int index, @Nonnull Iterable<? extends T> values) {
        return this.insertAll(index, this.nodeFromIterable(values));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAll(int index, @Nonnull Iterator<? extends T> values) {
        return this.insertAll(index, TreeBuilder.nodeFromIterator(values));
    }

    @Override
    @Nonnull
    private JImmutableTreeList<T> insertAll(int index, @Nonnull AbstractNode<T> other) {
        return JImmutableTreeList.create(this.root.prefix(index).append(other).append(this.root.suffix(index)));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAllFirst(@Nonnull Iterable<? extends T> values) {
        return this.insertAllFirst(this.nodeFromIterable(values));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAllFirst(@Nonnull Iterator<? extends T> values) {
        return this.insertAllFirst(TreeBuilder.nodeFromIterator(values));
    }

    @Override
    @Nonnull
    private JImmutableTreeList<T> insertAllFirst(@Nonnull AbstractNode<T> other) {
        return JImmutableTreeList.create(this.root.prepend(other));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAllLast(@Nonnull Iterable<? extends T> values) {
        return this.insertAllLast(this.nodeFromIterable(values));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> insertAllLast(@Nonnull Iterator<? extends T> values) {
        return this.insertAllLast(TreeBuilder.nodeFromIterator(values));
    }

    @Override
    @Nonnull
    private JImmutableTreeList<T> insertAllLast(@Nonnull AbstractNode<T> other) {
        return JImmutableTreeList.create(this.root.append(other));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> deleteFirst() {
        return JImmutableTreeList.create(this.root.deleteFirst());
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> deleteLast() {
        return JImmutableTreeList.create(this.root.deleteLast());
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> delete(int index) {
        return JImmutableTreeList.create(this.root.delete(index));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> deleteAll() {
        return JImmutableTreeList.of();
    }

    @Override
    @Nonnull
    public JImmutableList<T> reverse() {
        AbstractNode<T> newRoot = this.root.reverse();
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableTreeList<T>(newRoot);
    }

    @Override
    public <A> JImmutableTreeList<A> transform(@Nonnull Func1<T, A> transform) {
        ListBuilder builder = new ListBuilder();
        this.root.forEach(t -> builder.add(transform.apply((Object)t)));
        return builder.build();
    }

    @Override
    public <A> JImmutableTreeList<A> transformSome(@Nonnull Func1<T, Holder<A>> transform) {
        ListBuilder builder = new ListBuilder();
        this.root.forEach(t -> ((Holder)transform.apply((Object)t)).ifPresent(builder::add));
        return builder.build();
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public T get(int index) {
        return this.root.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public boolean isNonEmpty() {
        return !this.root.isEmpty();
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> select(@Nonnull Predicate<T> predicate) {
        ListBuilder answer = JImmutableTreeList.listBuilder();
        this.root.forEach(value -> {
            if (predicate.test(value)) {
                answer.add(value);
            }
        });
        return answer.size() == this.size() ? this : answer.build();
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> reject(@Nonnull Predicate<T> predicate) {
        MutableDelta index = new MutableDelta();
        AbstractNode newRoot = this.root.reduce(this.root, (answer, value) -> {
            assert (value == answer.get(index.getValue()));
            if (predicate.test(value)) {
                answer = answer.delete(index.getValue());
            } else {
                index.add(1);
            }
            return answer;
        });
        if (newRoot.isEmpty()) {
            return JImmutableTreeList.of();
        }
        if (newRoot == this.root) {
            return this;
        }
        return new JImmutableTreeList<T>(newRoot);
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> prefix(int limit) {
        return JImmutableTreeList.create(this.root.prefix(limit));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> suffix(int offset) {
        return JImmutableTreeList.create(this.root.suffix(offset));
    }

    @Override
    @Nonnull
    public JImmutableTreeList<T> middle(int offset, int limit) {
        return JImmutableTreeList.create(this.root.prefix(limit).suffix(offset));
    }

    @Override
    @Nonnull
    public JImmutableList<T> slice(int offset, int limit) {
        int size = this.root.size();
        if (offset < 0) {
            offset = size + offset;
        }
        if (limit < 0) {
            limit = size + limit + 1;
        }
        if (offset < 0) {
            offset = 0;
        } else if (offset > size) {
            offset = size;
        }
        if (limit < offset) {
            limit = offset;
        } else if (limit > size) {
            limit = size;
        }
        return this.middle(offset, limit);
    }

    @Override
    @Nonnull
    public List<T> getList() {
        return new ListAdaptor(this);
    }

    @Override
    @Nonnull
    public JImmutableList<T> getInsertableSelf() {
        return this;
    }

    @Override
    public void checkInvariants() {
        this.root.checkInvariants();
    }

    @Override
    @Nonnull
    public SplitableIterator<T> iterator() {
        return this.root.iterator();
    }

    @Override
    public int getSpliteratorCharacteristics() {
        return 1040;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JImmutableList && IteratorHelper.iteratorEquals(this.iterator(), ((JImmutableList)o).iterator());
    }

    public int hashCode() {
        return IteratorHelper.iteratorHashCode(this.iterator());
    }

    public String toString() {
        return IteratorHelper.iteratorToString(this.iterator());
    }

    private Object writeReplace() {
        return new JImmutableListProxy(this);
    }

    @Nonnull
    private AbstractNode<T> nodeFromIterable(@Nonnull Iterable<? extends T> values) {
        AbstractNode<Object> otherRoot = values instanceof JImmutableTreeList ? ((JImmutableTreeList)values).root : (values instanceof List ? TreeBuilder.nodeFromIndexed(IndexedList.retained((List)values)) : TreeBuilder.nodeFromIterator(values.iterator()));
        return otherRoot;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.root.forEach(action);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
        this.root.forEachThrows(proc);
    }

    @Override
    public <V> V reduce(V initialValue, Func2<V, T, V> accumulator) {
        return this.root.reduce(initialValue, accumulator);
    }

    @Override
    public <V, E extends Exception> V reduceThrows(V initialValue, Sum1Throws<T, V, E> accumulator) throws E {
        return this.root.reduceThrows(initialValue, accumulator);
    }

    @ThreadSafe
    public static class ListBuilder<T>
    implements JImmutableList.Builder<T> {
        private final TreeBuilder<T> builder = new TreeBuilder();

        @Override
        @Nonnull
        public synchronized JImmutableTreeList<T> build() {
            return JImmutableTreeList.create(this.builder.build());
        }

        @Nonnull
        public synchronized ListBuilder<T> combineWith(@Nonnull ListBuilder<T> other) {
            this.builder.combineWith(other.builder);
            return this;
        }

        @Override
        public synchronized int size() {
            return this.builder.size();
        }

        @Override
        @Nonnull
        public synchronized ListBuilder<T> add(T value) {
            this.builder.add(value);
            return this;
        }

        @Override
        @Nonnull
        public synchronized ListBuilder<T> add(Iterator<? extends T> source) {
            this.builder.add(source);
            return this;
        }

        @Override
        @Nonnull
        public synchronized ListBuilder<T> add(Iterable<? extends T> source) {
            this.builder.add(source);
            return this;
        }

        @Override
        @Nonnull
        public synchronized <K extends T> ListBuilder<T> add(K ... source) {
            this.builder.add(source);
            return this;
        }

        @Override
        @Nonnull
        public synchronized ListBuilder<T> add(Indexed<? extends T> source, int offset, int limit) {
            this.builder.add(source, offset, limit);
            return this;
        }

        @Override
        @Nonnull
        public synchronized ListBuilder<T> add(Indexed<? extends T> source) {
            this.builder.add(source);
            return this;
        }

        @Override
        @Nonnull
        public synchronized ListBuilder<T> clear() {
            this.builder.clear();
            return this;
        }

        public synchronized void checkInvariants() {
            this.builder.checkInvariants();
        }
    }
}

