/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.ArrayList;
import org.javimmutable.collections.JImmutableList;
import org.javimmutable.collections.list.JImmutableTreeList;

public class ListAppendTimingComparison {
    public static void main(String[] argv) {
        Mode mode = argv.length == 0 ? Mode.LAST : Mode.valueOf(argv[0].replace("-", "_").toUpperCase());
        long startMillis = System.currentTimeMillis();
        ListAppendTimingComparison.runTest(mode);
        long elapsedMillis = System.currentTimeMillis() - startMillis;
        System.out.printf("%s  %d%n", new Object[]{mode, elapsedMillis});
    }

    private static void runTest(Mode mode) {
        for (int loop = 1; loop <= 10000; ++loop) {
            JImmutableList list = JImmutableTreeList.of();
            ArrayList<Integer> extras = new ArrayList<Integer>();
            block6: for (int length = 1; length <= 250; ++length) {
                extras.add(length);
                switch (mode) {
                    case FIRST: {
                        list = list.insertAllFirst(extras);
                        continue block6;
                    }
                    case MIDDLE: {
                        list = list.insertAll(list.size() / 2, extras);
                        continue block6;
                    }
                    case LAST: {
                        list = list.insertAllLast(extras);
                    }
                }
            }
        }
    }

    private static enum Mode {
        FIRST,
        MIDDLE,
        LAST;

    }
}

