/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Func1;
import org.javimmutable.collections.Holder;
import org.javimmutable.collections.Holders;
import org.javimmutable.collections.JImmutableMap;
import org.javimmutable.collections.MapEntry;
import org.javimmutable.collections.Proc2;
import org.javimmutable.collections.Proc2Throws;
import org.javimmutable.collections.Sum2;
import org.javimmutable.collections.Sum2Throws;
import org.javimmutable.collections.common.CollisionMap;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.MultiValueNode;
import org.javimmutable.collections.list.OneValueNode;

public class ListCollisionMap<K, V>
implements CollisionMap<K, V> {
    private static final ListCollisionMap INSTANCE = new ListCollisionMap();

    private ListCollisionMap() {
    }

    @Nonnull
    public static <K, V> ListCollisionMap<K, V> instance() {
        return INSTANCE;
    }

    @Nonnull
    private AbstractNode<JImmutableMap.Entry<K, V>> root(@Nonnull CollisionMap.Node node) {
        return (AbstractNode)node;
    }

    @Override
    @Nonnull
    public CollisionMap.Node empty() {
        return EmptyNode.instance();
    }

    @Override
    @Nonnull
    public CollisionMap.Node single(@Nonnull K key, @Nullable V value) {
        return new OneValueNode<JImmutableMap.Entry<K, V>>(MapEntry.entry(key, value));
    }

    @Override
    @Nonnull
    public CollisionMap.Node dual(@Nonnull K key1, @Nullable V value1, @Nonnull K key2, @Nullable V value2) {
        return new MultiValueNode<JImmutableMap.Entry<K, V>>(MapEntry.entry(key1, value1), MapEntry.entry(key2, value2));
    }

    @Override
    public int size(@Nonnull CollisionMap.Node node) {
        return this.root(node).size();
    }

    @Override
    @Nonnull
    public CollisionMap.Node update(@Nonnull CollisionMap.Node node, @Nonnull K key, @Nullable V value) {
        AbstractNode<JImmutableMap.Entry<K, V>> root = this.root(node);
        int i = 0;
        for (JImmutableMap.Entry entry : root) {
            if (entry.getKey().equals(key)) {
                if (entry.getValue() == value) {
                    return root;
                }
                return root.assign(i, MapEntry.entry(key, value));
            }
            ++i;
        }
        return root.append(MapEntry.entry(key, value));
    }

    @Override
    @Nonnull
    public CollisionMap.Node update(@Nonnull CollisionMap.Node node, @Nonnull K key, @Nonnull Func1<Holder<V>, V> generator) {
        AbstractNode<JImmutableMap.Entry<K, V>> root = this.root(node);
        int i = 0;
        for (JImmutableMap.Entry entry : root) {
            if (entry.getKey().equals(key)) {
                V value = generator.apply(Holders.of(entry.getValue()));
                if (entry.getValue() == value) {
                    return root;
                }
                return root.assign(i, MapEntry.entry(key, value));
            }
            ++i;
        }
        V value = generator.apply(Holders.of());
        return root.append(MapEntry.entry(key, value));
    }

    @Override
    @Nonnull
    public CollisionMap.Node delete(@Nonnull CollisionMap.Node node, @Nonnull K key) {
        AbstractNode<JImmutableMap.Entry<K, V>> root = this.root(node);
        int i = 0;
        for (JImmutableMap.Entry entry : root) {
            if (entry.getKey().equals(key)) {
                return root.delete(i);
            }
            ++i;
        }
        return root;
    }

    @Override
    public V getValueOr(@Nonnull CollisionMap.Node node, @Nonnull K key, V defaultValue) {
        AbstractNode<JImmutableMap.Entry<K, V>> root = this.root(node);
        for (JImmutableMap.Entry entry : root) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return defaultValue;
    }

    @Override
    @Nonnull
    public Holder<V> findValue(@Nonnull CollisionMap.Node node, @Nonnull K key) {
        AbstractNode<JImmutableMap.Entry<K, V>> root = this.root(node);
        for (JImmutableMap.Entry entry : root) {
            if (!entry.getKey().equals(key)) continue;
            return Holders.of(entry.getValue());
        }
        return Holders.of();
    }

    @Override
    @Nonnull
    public Holder<JImmutableMap.Entry<K, V>> findEntry(@Nonnull CollisionMap.Node node, @Nonnull K key) {
        AbstractNode<JImmutableMap.Entry<K, V>> root = this.root(node);
        for (JImmutableMap.Entry entry : root) {
            if (!entry.getKey().equals(key)) continue;
            return Holders.of(entry);
        }
        return Holders.of();
    }

    @Override
    @Nonnull
    public JImmutableMap.Entry<K, V> first(@Nonnull CollisionMap.Node node) {
        return this.root(node).get(0);
    }

    @Override
    @Nullable
    public GenericIterator.State<JImmutableMap.Entry<K, V>> iterateOverRange(@Nonnull CollisionMap.Node node, @Nullable GenericIterator.State<JImmutableMap.Entry<K, V>> parent, int offset, int limit) {
        return this.root(node).iterateOverRange(parent, offset, limit);
    }

    @Override
    public void forEach(@Nonnull CollisionMap.Node node, @Nonnull Proc2<K, V> proc) {
        this.root(node).forEach(e -> proc.apply(e.getKey(), e.getValue()));
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionMap.Node node, @Nonnull Proc2Throws<K, V, E> proc) throws E {
        this.root(node).forEachThrows(e -> proc.apply(e.getKey(), e.getValue()));
    }

    @Override
    public <R> R reduce(@Nonnull CollisionMap.Node node, R sum, @Nonnull Sum2<K, V, R> proc) {
        return (R)this.root(node).reduce(sum, (s, e) -> proc.apply(s, e.getKey(), e.getValue()));
    }

    @Override
    public <R, E extends Exception> R reduceThrows(@Nonnull CollisionMap.Node node, R sum, @Nonnull Sum2Throws<K, V, R, E> proc) throws E {
        return (R)this.root(node).reduceThrows(sum, (s, e) -> proc.apply(s, e.getKey(), e.getValue()));
    }
}

