/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.javimmutable.collections.Proc1;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.Sum1;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.common.CollisionSet;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.MultiValueNode;
import org.javimmutable.collections.list.OneValueNode;

public class ListCollisionSet<T>
implements CollisionSet<T> {
    private static final ListCollisionSet INSTANCE = new ListCollisionSet();

    private ListCollisionSet() {
    }

    @Nonnull
    public static <T> ListCollisionSet<T> instance() {
        return INSTANCE;
    }

    @Nonnull
    private AbstractNode<T> root(@Nonnull CollisionSet.Node node) {
        return (AbstractNode)node;
    }

    @Override
    @Nonnull
    public CollisionSet.Node empty() {
        return EmptyNode.instance();
    }

    @Override
    @Nonnull
    public CollisionSet.Node single(@Nonnull T value) {
        return new OneValueNode<T>(value);
    }

    @Override
    @Nonnull
    public CollisionSet.Node dual(@Nonnull T value1, @Nonnull T value2) {
        return new MultiValueNode<T>(value1, value2);
    }

    @Override
    public int size(@Nonnull CollisionSet.Node node) {
        return this.root(node).size();
    }

    @Override
    public boolean contains(@Nonnull CollisionSet.Node node, @Nonnull T value) {
        for (Object v : this.root(node)) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public CollisionSet.Node insert(@Nonnull CollisionSet.Node node, @Nonnull T value) {
        AbstractNode<T> root = this.root(node);
        int i = 0;
        for (Object v : root) {
            if (v.equals(value)) {
                return root;
            }
            ++i;
        }
        return root.append(value);
    }

    @Override
    @Nonnull
    public CollisionSet.Node delete(@Nonnull CollisionSet.Node node, @Nonnull T value) {
        AbstractNode<T> root = this.root(node);
        int i = 0;
        for (Object v : root) {
            if (v.equals(value)) {
                return root.delete(i);
            }
            ++i;
        }
        return root;
    }

    @Override
    @Nonnull
    public T first(@Nonnull CollisionSet.Node node) {
        return this.root(node).get(0);
    }

    @Override
    @Nullable
    public GenericIterator.State<T> iterateOverRange(@Nonnull CollisionSet.Node node, @Nullable GenericIterator.State<T> parent, int offset, int limit) {
        return this.root(node).iterateOverRange(parent, offset, limit);
    }

    @Override
    public void forEach(@Nonnull CollisionSet.Node node, @Nonnull Proc1<T> proc) {
        this.root(node).forEach(proc::apply);
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull CollisionSet.Node node, @Nonnull Proc1Throws<T, E> proc) throws E {
        this.root(node).forEachThrows(proc);
    }

    @Override
    public <R> R reduce(@Nonnull CollisionSet.Node node, R sum, @Nonnull Sum1<T, R> proc) {
        return (R)this.root(node).reduce(sum, proc::apply);
    }

    @Override
    public <R, E extends Exception> R reduceThrows(@Nonnull CollisionSet.Node node, R sum, @Nonnull Sum1Throws<T, R, E> proc) throws E {
        return this.root(node).reduceThrows(sum, proc);
    }
}

