/*
 * Decompiled with CFR 0.152.
 */
package org.javimmutable.collections.list;

import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.javimmutable.collections.Func2;
import org.javimmutable.collections.Proc1Throws;
import org.javimmutable.collections.Sum1Throws;
import org.javimmutable.collections.common.ArrayHelper;
import org.javimmutable.collections.common.ToStringHelper;
import org.javimmutable.collections.indexed.IndexedArray;
import org.javimmutable.collections.iterators.GenericIterator;
import org.javimmutable.collections.list.AbstractNode;
import org.javimmutable.collections.list.BranchNode;
import org.javimmutable.collections.list.EmptyNode;
import org.javimmutable.collections.list.OneValueNode;

@Immutable
class MultiValueNode<T>
extends AbstractNode<T>
implements ArrayHelper.Allocator<T> {
    static final int MAX_SIZE = 128;
    static final int SPLIT_SIZE = 64;
    private final T[] values;

    MultiValueNode(T a, T b) {
        this.values = this.allocate(2);
        this.values[0] = a;
        this.values[1] = b;
    }

    private MultiValueNode(T[] values) {
        assert (values.length > 1);
        assert (values.length <= 128);
        this.values = values;
    }

    MultiValueNode(T[] values, int count) {
        assert (count > 1);
        assert (count <= 128);
        this.values = this.allocate(count);
        System.arraycopy(values, 0, this.values, 0, count);
    }

    MultiValueNode(@Nonnull AbstractNode<T> left, @Nonnull AbstractNode<T> right, int size) {
        assert (size > 1);
        assert (size <= 128);
        assert (size == left.size() + right.size());
        this.values = this.allocate(size);
        left.copyTo(this.values, 0);
        right.copyTo(this.values, left.size());
    }

    @Override
    boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    int size() {
        return this.values.length;
    }

    @Override
    int depth() {
        return 0;
    }

    @Override
    T get(int index) {
        return this.values[index];
    }

    @Override
    @Nonnull
    AbstractNode<T> append(T value) {
        return this.insert(this.values.length, value);
    }

    @Override
    @Nonnull
    AbstractNode<T> append(@Nonnull AbstractNode<T> node) {
        if (node.isEmpty()) {
            return this;
        }
        if (node.depth() > 0) {
            return node.prepend(this);
        }
        int combinedSize = this.size() + node.size();
        if (combinedSize <= 128) {
            return new MultiValueNode<T>(this, node, combinedSize);
        }
        return new BranchNode<T>(this, node, combinedSize);
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(T value) {
        return this.insert(0, value);
    }

    @Override
    @Nonnull
    AbstractNode<T> prepend(@Nonnull AbstractNode<T> node) {
        if (node.isEmpty()) {
            return this;
        }
        if (node.depth() > 0) {
            return node.append(this);
        }
        int combinedSize = this.size() + node.size();
        if (combinedSize <= 128) {
            return new MultiValueNode<T>(node, this, combinedSize);
        }
        return new BranchNode<T>(node, this, combinedSize);
    }

    @Override
    @Nonnull
    AbstractNode<T> assign(int index, T value) {
        return new MultiValueNode<T>(ArrayHelper.assign(this.values, index, value));
    }

    @Override
    @Nonnull
    AbstractNode<T> insert(int index, T value) {
        T[] right;
        T[] left;
        if (this.values.length < 128) {
            return new MultiValueNode<T>(ArrayHelper.insert(this, this.values, index, value));
        }
        if (index <= 64) {
            left = ArrayHelper.prefixInsert(this, this.values, 64, index, value);
            right = ArrayHelper.suffix(this, this.values, 64);
        } else {
            left = ArrayHelper.prefix(this, this.values, 64);
            right = ArrayHelper.suffixInsert(this, this.values, 64, index, value);
        }
        return new BranchNode<T>(new MultiValueNode<T>(left), new MultiValueNode<T>(right));
    }

    @Override
    @Nonnull
    AbstractNode<T> delete(int index) {
        int length = this.values.length;
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 1) {
            ArrayHelper.checkBounds(this.values, index);
            return EmptyNode.instance();
        }
        if (length == 2) {
            return new OneValueNode<T>(this.values[1 - index]);
        }
        return new MultiValueNode<T>(ArrayHelper.delete(this, this.values, index));
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteFirst() {
        return this.delete(0);
    }

    @Override
    @Nonnull
    AbstractNode<T> deleteLast() {
        return this.delete(this.values.length - 1);
    }

    @Override
    void copyTo(T[] array, int offset) {
        System.arraycopy(this.values, 0, array, offset, this.values.length);
    }

    @Override
    @Nonnull
    AbstractNode<T> prefix(int limit) {
        int length = this.values.length;
        if (limit < 0 || limit > length) {
            throw new IndexOutOfBoundsException();
        }
        if (limit == 0) {
            return EmptyNode.instance();
        }
        if (limit == length) {
            return this;
        }
        if (limit == 1) {
            return new OneValueNode<T>(this.values[0]);
        }
        return new MultiValueNode<T>(ArrayHelper.prefix(this, this.values, limit));
    }

    @Override
    @Nonnull
    AbstractNode<T> suffix(int offset) {
        int length = this.values.length;
        if (offset < 0 || offset > length) {
            throw new IndexOutOfBoundsException();
        }
        if (offset == 0) {
            return this;
        }
        if (offset == length - 1) {
            return new OneValueNode<T>(this.values[offset]);
        }
        if (offset == length) {
            return EmptyNode.instance();
        }
        return new MultiValueNode<T>(ArrayHelper.suffix(this, this.values, offset));
    }

    @Override
    @Nonnull
    AbstractNode<T> reverse() {
        return new MultiValueNode<T>(ArrayHelper.reverse(this, this.values));
    }

    @Override
    @Nonnull
    public T[] allocate(int size) {
        assert (size > 0);
        return new Object[size];
    }

    @Override
    public void checkInvariants() {
        int currentSize = this.values.length;
        if (currentSize < 1 || currentSize > 128) {
            throw new RuntimeException(String.format("incorrect size: currentSize=%d", currentSize));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValueNode leafNode = (MultiValueNode)o;
        return Arrays.equals(this.values, leafNode.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return ToStringHelper.arrayToString(this.values);
    }

    @Override
    @Nullable
    public GenericIterator.State<T> iterateOverRange(@Nullable GenericIterator.State<T> parent, int offset, int limit) {
        assert (offset >= 0 && offset <= limit && limit <= this.values.length);
        return GenericIterator.multiValueState(parent, IndexedArray.retained(this.values), offset, limit);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (T value : this.values) {
            action.accept(value);
        }
    }

    @Override
    public <E extends Exception> void forEachThrows(@Nonnull Proc1Throws<T, E> proc) throws E {
        for (T value : this.values) {
            proc.apply(value);
        }
    }

    @Override
    public <V> V reduce(V sum, Func2<V, T, V> accumulator) {
        for (T value : this.values) {
            sum = accumulator.apply(sum, value);
        }
        return sum;
    }

    @Override
    public <V, E extends Exception> V reduceThrows(V sum, Sum1Throws<T, V, E> accumulator) throws E {
        for (T value : this.values) {
            sum = accumulator.apply(sum, value);
        }
        return sum;
    }
}

